package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobDefinition(
    jobDefinitionName: String,
    jobDefinitionArn: String,
    revision: Integer,
    status: Optional[String] = Optional.Absent,
    `type`: String,
    schedulingPriority: Optional[Integer] = Optional.Absent,
    parameters: Optional[Map[String, String]] = Optional.Absent,
    retryStrategy: Optional[zio.aws.batch.model.RetryStrategy] =
      Optional.Absent,
    containerProperties: Optional[zio.aws.batch.model.ContainerProperties] =
      Optional.Absent,
    timeout: Optional[zio.aws.batch.model.JobTimeout] = Optional.Absent,
    nodeProperties: Optional[zio.aws.batch.model.NodeProperties] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    propagateTags: Optional[Boolean] = Optional.Absent,
    platformCapabilities: Optional[
      Iterable[zio.aws.batch.model.PlatformCapability]
    ] = Optional.Absent,
    eksProperties: Optional[zio.aws.batch.model.EksProperties] =
      Optional.Absent,
    containerOrchestrationType: Optional[
      zio.aws.batch.model.OrchestrationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.JobDefinition = {
    import JobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.JobDefinition
      .builder()
      .jobDefinitionName(jobDefinitionName: java.lang.String)
      .jobDefinitionArn(jobDefinitionArn: java.lang.String)
      .revision(revision: java.lang.Integer)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .`type`(`type`: java.lang.String)
      .optionallyWith(
        schedulingPriority.map(value => value: java.lang.Integer)
      )(_.schedulingPriority)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .optionallyWith(containerProperties.map(value => value.buildAwsValue()))(
        _.containerProperties
      )
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .optionallyWith(nodeProperties.map(value => value.buildAwsValue()))(
        _.nodeProperties
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(propagateTags.map(value => value: java.lang.Boolean))(
        _.propagateTags
      )
      .optionallyWith(
        platformCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformCapabilitiesWithStrings)
      .optionallyWith(eksProperties.map(value => value.buildAwsValue()))(
        _.eksProperties
      )
      .optionallyWith(containerOrchestrationType.map(value => value.unwrap))(
        _.containerOrchestrationType
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.JobDefinition.ReadOnly =
    zio.aws.batch.model.JobDefinition.wrap(buildAwsValue())
}
object JobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.JobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.JobDefinition =
      zio.aws.batch.model.JobDefinition(
        jobDefinitionName,
        jobDefinitionArn,
        revision,
        status.map(value => value),
        `type`,
        schedulingPriority.map(value => value),
        parameters.map(value => value),
        retryStrategy.map(value => value.asEditable),
        containerProperties.map(value => value.asEditable),
        timeout.map(value => value.asEditable),
        nodeProperties.map(value => value.asEditable),
        tags.map(value => value),
        propagateTags.map(value => value),
        platformCapabilities.map(value => value),
        eksProperties.map(value => value.asEditable),
        containerOrchestrationType.map(value => value)
      )
    def jobDefinitionName: String
    def jobDefinitionArn: String
    def revision: Integer
    def status: Optional[String]
    def `type`: String
    def schedulingPriority: Optional[Integer]
    def parameters: Optional[Map[String, String]]
    def retryStrategy: Optional[zio.aws.batch.model.RetryStrategy.ReadOnly]
    def containerProperties
        : Optional[zio.aws.batch.model.ContainerProperties.ReadOnly]
    def timeout: Optional[zio.aws.batch.model.JobTimeout.ReadOnly]
    def nodeProperties: Optional[zio.aws.batch.model.NodeProperties.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def propagateTags: Optional[Boolean]
    def platformCapabilities
        : Optional[List[zio.aws.batch.model.PlatformCapability]]
    def eksProperties: Optional[zio.aws.batch.model.EksProperties.ReadOnly]
    def containerOrchestrationType
        : Optional[zio.aws.batch.model.OrchestrationType]
    def getJobDefinitionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(jobDefinitionName)
    def getJobDefinitionArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(jobDefinitionArn)
    def getRevision: ZIO[Any, Nothing, Integer] = ZIO.succeed(revision)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getSchedulingPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("schedulingPriority", schedulingPriority)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.batch.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getContainerProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerProperties.ReadOnly] =
      AwsError.unwrapOptionField("containerProperties", containerProperties)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.batch.model.JobTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getNodeProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.NodeProperties.ReadOnly] =
      AwsError.unwrapOptionField("nodeProperties", nodeProperties)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPropagateTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getPlatformCapabilities
        : ZIO[Any, AwsError, List[zio.aws.batch.model.PlatformCapability]] =
      AwsError.unwrapOptionField("platformCapabilities", platformCapabilities)
    def getEksProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.EksProperties.ReadOnly] =
      AwsError.unwrapOptionField("eksProperties", eksProperties)
    def getContainerOrchestrationType
        : ZIO[Any, AwsError, zio.aws.batch.model.OrchestrationType] =
      AwsError.unwrapOptionField(
        "containerOrchestrationType",
        containerOrchestrationType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.JobDefinition
  ) extends zio.aws.batch.model.JobDefinition.ReadOnly {
    override val jobDefinitionName: String = impl.jobDefinitionName(): String
    override val jobDefinitionArn: String = impl.jobDefinitionArn(): String
    override val revision: Integer = impl.revision(): Integer
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val `type`: String = impl.`type`(): String
    override val schedulingPriority: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingPriority())
      .map(value => value: Integer)
    override val parameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val retryStrategy
        : Optional[zio.aws.batch.model.RetryStrategy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryStrategy())
        .map(value => zio.aws.batch.model.RetryStrategy.wrap(value))
    override val containerProperties
        : Optional[zio.aws.batch.model.ContainerProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerProperties())
        .map(value => zio.aws.batch.model.ContainerProperties.wrap(value))
    override val timeout: Optional[zio.aws.batch.model.JobTimeout.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeout())
        .map(value => zio.aws.batch.model.JobTimeout.wrap(value))
    override val nodeProperties
        : Optional[zio.aws.batch.model.NodeProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeProperties())
        .map(value => zio.aws.batch.model.NodeProperties.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val propagateTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.propagateTags())
      .map(value => value: Boolean)
    override val platformCapabilities
        : Optional[List[zio.aws.batch.model.PlatformCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformCapabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.PlatformCapability.wrap(item)
          }.toList
        )
    override val eksProperties
        : Optional[zio.aws.batch.model.EksProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eksProperties())
        .map(value => zio.aws.batch.model.EksProperties.wrap(value))
    override val containerOrchestrationType
        : Optional[zio.aws.batch.model.OrchestrationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerOrchestrationType())
        .map(value => zio.aws.batch.model.OrchestrationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.JobDefinition
  ): zio.aws.batch.model.JobDefinition.ReadOnly = new Wrapper(impl)
}
