package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodePropertiesSummary(
    isMainNode: Optional[Boolean] = Optional.Absent,
    numNodes: Optional[Integer] = Optional.Absent,
    nodeIndex: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.NodePropertiesSummary = {
    import NodePropertiesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.NodePropertiesSummary
      .builder()
      .optionallyWith(isMainNode.map(value => value: java.lang.Boolean))(
        _.isMainNode
      )
      .optionallyWith(numNodes.map(value => value: java.lang.Integer))(
        _.numNodes
      )
      .optionallyWith(nodeIndex.map(value => value: java.lang.Integer))(
        _.nodeIndex
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.NodePropertiesSummary.ReadOnly =
    zio.aws.batch.model.NodePropertiesSummary.wrap(buildAwsValue())
}
object NodePropertiesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.NodePropertiesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.NodePropertiesSummary =
      zio.aws.batch.model.NodePropertiesSummary(
        isMainNode.map(value => value),
        numNodes.map(value => value),
        nodeIndex.map(value => value)
      )
    def isMainNode: Optional[Boolean]
    def numNodes: Optional[Integer]
    def nodeIndex: Optional[Integer]
    def getIsMainNode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMainNode", isMainNode)
    def getNumNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numNodes", numNodes)
    def getNodeIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("nodeIndex", nodeIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.NodePropertiesSummary
  ) extends zio.aws.batch.model.NodePropertiesSummary.ReadOnly {
    override val isMainNode: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isMainNode())
      .map(value => value: Boolean)
    override val numNodes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.numNodes())
      .map(value => value: Integer)
    override val nodeIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeIndex())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.NodePropertiesSummary
  ): zio.aws.batch.model.NodePropertiesSummary.ReadOnly = new Wrapper(impl)
}
