package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait LogDriver {
  def unwrap: software.amazon.awssdk.services.batch.model.LogDriver
}
object LogDriver {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.LogDriver
  ): zio.aws.batch.model.LogDriver = value match {
    case software.amazon.awssdk.services.batch.model.LogDriver.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.LogDriver.JSON_FILE =>
      val r = `json-file`
      r
    case software.amazon.awssdk.services.batch.model.LogDriver.SYSLOG =>
      val r = syslog
      r
    case software.amazon.awssdk.services.batch.model.LogDriver.JOURNALD =>
      val r = journald
      r
    case software.amazon.awssdk.services.batch.model.LogDriver.GELF =>
      val r = gelf
      r
    case software.amazon.awssdk.services.batch.model.LogDriver.FLUENTD =>
      val r = fluentd
      r
    case software.amazon.awssdk.services.batch.model.LogDriver.AWSLOGS =>
      val r = awslogs
      r
    case software.amazon.awssdk.services.batch.model.LogDriver.SPLUNK =>
      val r = splunk
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.UNKNOWN_TO_SDK_VERSION
  }
  case object `json-file` extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.JSON_FILE
  }
  case object syslog extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.SYSLOG
  }
  case object journald extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.JOURNALD
  }
  case object gelf extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.GELF
  }
  case object fluentd extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.FLUENTD
  }
  case object awslogs extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.AWSLOGS
  }
  case object splunk extends zio.aws.batch.model.LogDriver {
    override def unwrap: software.amazon.awssdk.services.batch.model.LogDriver =
      software.amazon.awssdk.services.batch.model.LogDriver.SPLUNK
  }
}
