package zio.aws.batch.model
import zio.aws.batch.model.primitives.Quantity
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksEmptyDir(
    medium: Optional[String] = Optional.Absent,
    sizeLimit: Optional[Quantity] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksEmptyDir = {
    import EksEmptyDir.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksEmptyDir
      .builder()
      .optionallyWith(medium.map(value => value: java.lang.String))(_.medium)
      .optionallyWith(
        sizeLimit.map(value => Quantity.unwrap(value): java.lang.String)
      )(_.sizeLimit)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksEmptyDir.ReadOnly =
    zio.aws.batch.model.EksEmptyDir.wrap(buildAwsValue())
}
object EksEmptyDir {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.EksEmptyDir] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksEmptyDir = zio.aws.batch.model
      .EksEmptyDir(medium.map(value => value), sizeLimit.map(value => value))
    def medium: Optional[String]
    def sizeLimit: Optional[Quantity]
    def getMedium: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("medium", medium)
    def getSizeLimit: ZIO[Any, AwsError, Quantity] =
      AwsError.unwrapOptionField("sizeLimit", sizeLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksEmptyDir
  ) extends zio.aws.batch.model.EksEmptyDir.ReadOnly {
    override val medium: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.medium())
      .map(value => value: String)
    override val sizeLimit: Optional[Quantity] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeLimit())
      .map(value => zio.aws.batch.model.primitives.Quantity(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksEmptyDir
  ): zio.aws.batch.model.EksEmptyDir.ReadOnly = new Wrapper(impl)
}
