package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateComputeEnvironmentResponse(
    computeEnvironmentName: Optional[String] = Optional.Absent,
    computeEnvironmentArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse = {
    import CreateComputeEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
      .builder()
      .optionallyWith(
        computeEnvironmentName.map(value => value: java.lang.String)
      )(_.computeEnvironmentName)
      .optionallyWith(
        computeEnvironmentArn.map(value => value: java.lang.String)
      )(_.computeEnvironmentArn)
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly =
    zio.aws.batch.model.CreateComputeEnvironmentResponse.wrap(buildAwsValue())
}
object CreateComputeEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CreateComputeEnvironmentResponse =
      zio.aws.batch.model.CreateComputeEnvironmentResponse(
        computeEnvironmentName.map(value => value),
        computeEnvironmentArn.map(value => value)
      )
    def computeEnvironmentName: Optional[String]
    def computeEnvironmentArn: Optional[String]
    def getComputeEnvironmentName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("computeEnvironmentName", computeEnvironmentName)
    def getComputeEnvironmentArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("computeEnvironmentArn", computeEnvironmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
  ) extends zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly {
    override val computeEnvironmentName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeEnvironmentName())
        .map(value => value: String)
    override val computeEnvironmentArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.computeEnvironmentArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
  ): zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
