package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksSecret(
    secretName: String,
    optional: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.EksSecret = {
    import EksSecret.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksSecret
      .builder()
      .secretName(secretName: java.lang.String)
      .optionallyWith(optional.map(value => value: java.lang.Boolean))(
        _.optional
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksSecret.ReadOnly =
    zio.aws.batch.model.EksSecret.wrap(buildAwsValue())
}
object EksSecret {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.EksSecret] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksSecret =
      zio.aws.batch.model.EksSecret(secretName, optional.map(value => value))
    def secretName: String
    def optional: Optional[Boolean]
    def getSecretName: ZIO[Any, Nothing, String] = ZIO.succeed(secretName)
    def getOptional: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("optional", optional)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksSecret
  ) extends zio.aws.batch.model.EksSecret.ReadOnly {
    override val secretName: String = impl.secretName(): String
    override val optional: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.optional())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksSecret
  ): zio.aws.batch.model.EksSecret.ReadOnly = new Wrapper(impl)
}
