package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Host(sourcePath: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.Host = {
    import Host.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.Host
      .builder()
      .optionallyWith(sourcePath.map(value => value: java.lang.String))(
        _.sourcePath
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.Host.ReadOnly =
    zio.aws.batch.model.Host.wrap(buildAwsValue())
}
object Host {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.Host] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.Host =
      zio.aws.batch.model.Host(sourcePath.map(value => value))
    def sourcePath: Optional[String]
    def getSourcePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourcePath", sourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.Host
  ) extends zio.aws.batch.model.Host.ReadOnly {
    override val sourcePath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePath())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.Host
  ): zio.aws.batch.model.Host.ReadOnly = new Wrapper(impl)
}
