package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksPodPropertiesOverride(
    containers: Optional[Iterable[zio.aws.batch.model.EksContainerOverride]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksPodPropertiesOverride = {
    import EksPodPropertiesOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksPodPropertiesOverride
      .builder()
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksPodPropertiesOverride.ReadOnly =
    zio.aws.batch.model.EksPodPropertiesOverride.wrap(buildAwsValue())
}
object EksPodPropertiesOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksPodPropertiesOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksPodPropertiesOverride =
      zio.aws.batch.model.EksPodPropertiesOverride(
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containers
        : Optional[List[zio.aws.batch.model.EksContainerOverride.ReadOnly]]
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.batch.model.EksContainerOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksPodPropertiesOverride
  ) extends zio.aws.batch.model.EksPodPropertiesOverride.ReadOnly {
    override val containers
        : Optional[List[zio.aws.batch.model.EksContainerOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EksContainerOverride.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksPodPropertiesOverride
  ): zio.aws.batch.model.EksPodPropertiesOverride.ReadOnly = new Wrapper(impl)
}
