package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait OrchestrationType {
  def unwrap: software.amazon.awssdk.services.batch.model.OrchestrationType
}
object OrchestrationType {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.OrchestrationType
  ): zio.aws.batch.model.OrchestrationType = value match {
    case software.amazon.awssdk.services.batch.model.OrchestrationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.OrchestrationType.ECS =>
      val r = ECS
      r
    case software.amazon.awssdk.services.batch.model.OrchestrationType.EKS =>
      val r = EKS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.OrchestrationType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.OrchestrationType =
      software.amazon.awssdk.services.batch.model.OrchestrationType.UNKNOWN_TO_SDK_VERSION
  }
  case object ECS extends zio.aws.batch.model.OrchestrationType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.OrchestrationType =
      software.amazon.awssdk.services.batch.model.OrchestrationType.ECS
  }
  case object EKS extends zio.aws.batch.model.OrchestrationType {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.OrchestrationType =
      software.amazon.awssdk.services.batch.model.OrchestrationType.EKS
  }
}
