package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    jobQueue: Optional[String] = Optional.Absent,
    arrayJobId: Optional[String] = Optional.Absent,
    multiNodeJobId: Optional[String] = Optional.Absent,
    jobStatus: Optional[zio.aws.batch.model.JobStatus] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.batch.model.KeyValuesPair]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ListJobsRequest
      .builder()
      .optionallyWith(jobQueue.map(value => value: java.lang.String))(
        _.jobQueue
      )
      .optionallyWith(arrayJobId.map(value => value: java.lang.String))(
        _.arrayJobId
      )
      .optionallyWith(multiNodeJobId.map(value => value: java.lang.String))(
        _.multiNodeJobId
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ListJobsRequest.ReadOnly =
    zio.aws.batch.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ListJobsRequest =
      zio.aws.batch.model.ListJobsRequest(
        jobQueue.map(value => value),
        arrayJobId.map(value => value),
        multiNodeJobId.map(value => value),
        jobStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobQueue: Optional[String]
    def arrayJobId: Optional[String]
    def multiNodeJobId: Optional[String]
    def jobStatus: Optional[zio.aws.batch.model.JobStatus]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def filters: Optional[List[zio.aws.batch.model.KeyValuesPair.ReadOnly]]
    def getJobQueue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobQueue", jobQueue)
    def getArrayJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arrayJobId", arrayJobId)
    def getMultiNodeJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("multiNodeJobId", multiNodeJobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.batch.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.batch.model.KeyValuesPair.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ListJobsRequest
  ) extends zio.aws.batch.model.ListJobsRequest.ReadOnly {
    override val jobQueue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.jobQueue())
      .map(value => value: String)
    override val arrayJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arrayJobId())
      .map(value => value: String)
    override val multiNodeJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.multiNodeJobId())
      .map(value => value: String)
    override val jobStatus: Optional[zio.aws.batch.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.batch.model.JobStatus.wrap(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val filters
        : Optional[List[zio.aws.batch.model.KeyValuesPair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.KeyValuesPair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ListJobsRequest
  ): zio.aws.batch.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
