package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Device(
    hostPath: String,
    containerPath: Optional[String] = Optional.Absent,
    permissions: Optional[
      Iterable[zio.aws.batch.model.DeviceCgroupPermission]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.Device
      .builder()
      .hostPath(hostPath: java.lang.String)
      .optionallyWith(containerPath.map(value => value: java.lang.String))(
        _.containerPath
      )
      .optionallyWith(
        permissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.permissionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.Device.ReadOnly =
    zio.aws.batch.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.Device] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.Device = zio.aws.batch.model.Device(
      hostPath,
      containerPath.map(value => value),
      permissions.map(value => value)
    )
    def hostPath: String
    def containerPath: Optional[String]
    def permissions: Optional[List[zio.aws.batch.model.DeviceCgroupPermission]]
    def getHostPath: ZIO[Any, Nothing, String] = ZIO.succeed(hostPath)
    def getContainerPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getPermissions
        : ZIO[Any, AwsError, List[zio.aws.batch.model.DeviceCgroupPermission]] =
      AwsError.unwrapOptionField("permissions", permissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.Device
  ) extends zio.aws.batch.model.Device.ReadOnly {
    override val hostPath: String = impl.hostPath(): String
    override val containerPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPath())
      .map(value => value: String)
    override val permissions
        : Optional[List[zio.aws.batch.model.DeviceCgroupPermission]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.DeviceCgroupPermission.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.Device
  ): zio.aws.batch.model.Device.ReadOnly = new Wrapper(impl)
}
