package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait RetryAction {
  def unwrap: software.amazon.awssdk.services.batch.model.RetryAction
}
object RetryAction {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.RetryAction
  ): zio.aws.batch.model.RetryAction = value match {
    case software.amazon.awssdk.services.batch.model.RetryAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.RetryAction.RETRY =>
      val r = RETRY
      r
    case software.amazon.awssdk.services.batch.model.RetryAction.EXIT =>
      val r = EXIT
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.RetryAction {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.RetryAction =
      software.amazon.awssdk.services.batch.model.RetryAction.UNKNOWN_TO_SDK_VERSION
  }
  case object RETRY extends zio.aws.batch.model.RetryAction {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.RetryAction =
      software.amazon.awssdk.services.batch.model.RetryAction.RETRY
  }
  case object EXIT extends zio.aws.batch.model.RetryAction {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.RetryAction =
      software.amazon.awssdk.services.batch.model.RetryAction.EXIT
  }
}
