package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksContainerSecurityContext(
    runAsUser: Optional[Long] = Optional.Absent,
    runAsGroup: Optional[Long] = Optional.Absent,
    privileged: Optional[Boolean] = Optional.Absent,
    readOnlyRootFilesystem: Optional[Boolean] = Optional.Absent,
    runAsNonRoot: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksContainerSecurityContext = {
    import EksContainerSecurityContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksContainerSecurityContext
      .builder()
      .optionallyWith(runAsUser.map(value => value: java.lang.Long))(
        _.runAsUser
      )
      .optionallyWith(runAsGroup.map(value => value: java.lang.Long))(
        _.runAsGroup
      )
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .optionallyWith(
        readOnlyRootFilesystem.map(value => value: java.lang.Boolean)
      )(_.readOnlyRootFilesystem)
      .optionallyWith(runAsNonRoot.map(value => value: java.lang.Boolean))(
        _.runAsNonRoot
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksContainerSecurityContext.ReadOnly =
    zio.aws.batch.model.EksContainerSecurityContext.wrap(buildAwsValue())
}
object EksContainerSecurityContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksContainerSecurityContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksContainerSecurityContext =
      zio.aws.batch.model.EksContainerSecurityContext(
        runAsUser.map(value => value),
        runAsGroup.map(value => value),
        privileged.map(value => value),
        readOnlyRootFilesystem.map(value => value),
        runAsNonRoot.map(value => value)
      )
    def runAsUser: Optional[Long]
    def runAsGroup: Optional[Long]
    def privileged: Optional[Boolean]
    def readOnlyRootFilesystem: Optional[Boolean]
    def runAsNonRoot: Optional[Boolean]
    def getRunAsUser: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("runAsUser", runAsUser)
    def getRunAsGroup: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("runAsGroup", runAsGroup)
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
    def getReadOnlyRootFilesystem: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("readOnlyRootFilesystem", readOnlyRootFilesystem)
    def getRunAsNonRoot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("runAsNonRoot", runAsNonRoot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksContainerSecurityContext
  ) extends zio.aws.batch.model.EksContainerSecurityContext.ReadOnly {
    override val runAsUser: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.runAsUser())
      .map(value => value: Long)
    override val runAsGroup: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.runAsGroup())
      .map(value => value: Long)
    override val privileged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: Boolean)
    override val readOnlyRootFilesystem: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readOnlyRootFilesystem())
        .map(value => value: Boolean)
    override val runAsNonRoot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.runAsNonRoot())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksContainerSecurityContext
  ): zio.aws.batch.model.EksContainerSecurityContext.ReadOnly = new Wrapper(
    impl
  )
}
