package zio.aws.batch.model
import zio.aws.batch.model.primitives.TagKey
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: String,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UntagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.UntagResourceRequest.ReadOnly =
    zio.aws.batch.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UntagResourceRequest =
      zio.aws.batch.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: String
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UntagResourceRequest
  ) extends zio.aws.batch.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.batch.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UntagResourceRequest
  ): zio.aws.batch.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
