package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait CEState {
  def unwrap: software.amazon.awssdk.services.batch.model.CEState
}
object CEState {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.CEState
  ): zio.aws.batch.model.CEState = value match {
    case software.amazon.awssdk.services.batch.model.CEState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.CEState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.batch.model.CEState.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.CEState {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEState =
      software.amazon.awssdk.services.batch.model.CEState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.batch.model.CEState {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEState =
      software.amazon.awssdk.services.batch.model.CEState.ENABLED
  }
  case object DISABLED extends zio.aws.batch.model.CEState {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEState =
      software.amazon.awssdk.services.batch.model.CEState.DISABLED
  }
}
