package zio.aws.batch
import zio.prelude.Subtype
import zio.aws.batch.model.primitives.{TagValue, TagKey, Quantity, Integer}
import zio.aws.batch.model.primitives.Quantity.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ImageIdOverride extends Subtype[String]
    type ImageIdOverride = zio.aws.batch.model.primitives.ImageIdOverride.Type
    object ImageType extends Subtype[String]
    type ImageType = zio.aws.batch.model.primitives.ImageType.Type
    type Integer = Int
    object JobExecutionTimeoutMinutes extends Subtype[Long]
    type JobExecutionTimeoutMinutes =
      zio.aws.batch.model.primitives.JobExecutionTimeoutMinutes.Type
    object KubernetesVersion extends Subtype[String]
    type KubernetesVersion =
      zio.aws.batch.model.primitives.KubernetesVersion.Type
    object Quantity extends Subtype[String]
    type Quantity = zio.aws.batch.model.primitives.Quantity.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.batch.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.batch.model.primitives.TagValue.Type
  }
  type ArrayJobStatusSummary = Map[String, Integer]
  type AttemptDetails = List[zio.aws.batch.model.AttemptDetail]
  type ComputeEnvironmentDetailList =
    List[zio.aws.batch.model.ComputeEnvironmentDetail]
  type ComputeEnvironmentOrders =
    List[zio.aws.batch.model.ComputeEnvironmentOrder]
  type DeviceCgroupPermissions =
    List[zio.aws.batch.model.DeviceCgroupPermission]
  type DevicesList = List[zio.aws.batch.model.Device]
  type Ec2ConfigurationList = List[zio.aws.batch.model.Ec2Configuration]
  type EksAttemptContainerDetails =
    List[zio.aws.batch.model.EksAttemptContainerDetail]
  type EksAttemptDetails = List[zio.aws.batch.model.EksAttemptDetail]
  type EksContainerDetails = List[zio.aws.batch.model.EksContainerDetail]
  type EksContainerEnvironmentVariables =
    List[zio.aws.batch.model.EksContainerEnvironmentVariable]
  type EksContainerOverrideList = List[zio.aws.batch.model.EksContainerOverride]
  type EksContainerVolumeMounts =
    List[zio.aws.batch.model.EksContainerVolumeMount]
  type EksContainers = List[zio.aws.batch.model.EksContainer]
  type EksLimits = Map[String, Quantity]
  type EksRequests = Map[String, Quantity]
  type EksVolumes = List[zio.aws.batch.model.EksVolume]
  type EnvironmentVariables = List[zio.aws.batch.model.KeyValuePair]
  type EvaluateOnExitList = List[zio.aws.batch.model.EvaluateOnExit]
  type JobDefinitionList = List[zio.aws.batch.model.JobDefinition]
  type JobDependencyList = List[zio.aws.batch.model.JobDependency]
  type JobDetailList = List[zio.aws.batch.model.JobDetail]
  type JobQueueDetailList = List[zio.aws.batch.model.JobQueueDetail]
  type JobSummaryList = List[zio.aws.batch.model.JobSummary]
  type ListJobsFilterList = List[zio.aws.batch.model.KeyValuesPair]
  type LogConfigurationOptionsMap = Map[String, String]
  type MountPoints = List[zio.aws.batch.model.MountPoint]
  type NetworkInterfaceList = List[zio.aws.batch.model.NetworkInterface]
  type NodePropertyOverrides = List[zio.aws.batch.model.NodePropertyOverride]
  type NodeRangeProperties = List[zio.aws.batch.model.NodeRangeProperty]
  type ParametersMap = Map[String, String]
  type PlatformCapabilityList = List[zio.aws.batch.model.PlatformCapability]
  type ResourceRequirements = List[zio.aws.batch.model.ResourceRequirement]
  type SchedulingPolicyDetailList =
    List[zio.aws.batch.model.SchedulingPolicyDetail]
  type SchedulingPolicyListingDetailList =
    List[zio.aws.batch.model.SchedulingPolicyListingDetail]
  type SecretList = List[zio.aws.batch.model.Secret]
  type ShareAttributesList = List[zio.aws.batch.model.ShareAttributes]
  type StringList = List[String]
  type TagKeysList = List[TagKey]
  type TagrisTagsMap = Map[TagKey, TagValue]
  type TagsMap = Map[String, String]
  type TmpfsList = List[zio.aws.batch.model.Tmpfs]
  type Ulimits = List[zio.aws.batch.model.Ulimit]
  type Volumes = List[zio.aws.batch.model.Volume]
}
