package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FargatePlatformConfiguration(
    platformVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.FargatePlatformConfiguration = {
    import FargatePlatformConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.FargatePlatformConfiguration
      .builder()
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly =
    zio.aws.batch.model.FargatePlatformConfiguration.wrap(buildAwsValue())
}
object FargatePlatformConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.FargatePlatformConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.FargatePlatformConfiguration =
      zio.aws.batch.model
        .FargatePlatformConfiguration(platformVersion.map(value => value))
    def platformVersion: Optional[String]
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.FargatePlatformConfiguration
  ) extends zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly {
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.FargatePlatformConfiguration
  ): zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
