package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksPodProperties(
    serviceAccountName: Optional[String] = Optional.Absent,
    hostNetwork: Optional[Boolean] = Optional.Absent,
    dnsPolicy: Optional[String] = Optional.Absent,
    containers: Optional[Iterable[zio.aws.batch.model.EksContainer]] =
      Optional.Absent,
    volumes: Optional[Iterable[zio.aws.batch.model.EksVolume]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksPodProperties = {
    import EksPodProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksPodProperties
      .builder()
      .optionallyWith(serviceAccountName.map(value => value: java.lang.String))(
        _.serviceAccountName
      )
      .optionallyWith(hostNetwork.map(value => value: java.lang.Boolean))(
        _.hostNetwork
      )
      .optionallyWith(dnsPolicy.map(value => value: java.lang.String))(
        _.dnsPolicy
      )
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EksPodProperties.ReadOnly =
    zio.aws.batch.model.EksPodProperties.wrap(buildAwsValue())
}
object EksPodProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksPodProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksPodProperties =
      zio.aws.batch.model.EksPodProperties(
        serviceAccountName.map(value => value),
        hostNetwork.map(value => value),
        dnsPolicy.map(value => value),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceAccountName: Optional[String]
    def hostNetwork: Optional[Boolean]
    def dnsPolicy: Optional[String]
    def containers: Optional[List[zio.aws.batch.model.EksContainer.ReadOnly]]
    def volumes: Optional[List[zio.aws.batch.model.EksVolume.ReadOnly]]
    def getServiceAccountName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccountName", serviceAccountName)
    def getHostNetwork: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hostNetwork", hostNetwork)
    def getDnsPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsPolicy", dnsPolicy)
    def getContainers
        : ZIO[Any, AwsError, List[zio.aws.batch.model.EksContainer.ReadOnly]] =
      AwsError.unwrapOptionField("containers", containers)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.batch.model.EksVolume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksPodProperties
  ) extends zio.aws.batch.model.EksPodProperties.ReadOnly {
    override val serviceAccountName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccountName())
      .map(value => value: String)
    override val hostNetwork: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hostNetwork())
      .map(value => value: Boolean)
    override val dnsPolicy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsPolicy())
      .map(value => value: String)
    override val containers
        : Optional[List[zio.aws.batch.model.EksContainer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EksContainer.wrap(item)
          }.toList
        )
    override val volumes
        : Optional[List[zio.aws.batch.model.EksVolume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.EksVolume.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksPodProperties
  ): zio.aws.batch.model.EksPodProperties.ReadOnly = new Wrapper(impl)
}
