package zio.aws.batch.model
import zio.aws.batch.model.primitives.Quantity
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EksContainerResourceRequirements(
    limits: Optional[Map[String, Quantity]] = Optional.Absent,
    requests: Optional[Map[String, Quantity]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EksContainerResourceRequirements = {
    import EksContainerResourceRequirements.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EksContainerResourceRequirements
      .builder()
      .optionallyWith(
        limits.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (Quantity
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.limits)
      .optionallyWith(
        requests.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (Quantity
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.requests)
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly =
    zio.aws.batch.model.EksContainerResourceRequirements.wrap(buildAwsValue())
}
object EksContainerResourceRequirements {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EksContainerResourceRequirements
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EksContainerResourceRequirements =
      zio.aws.batch.model.EksContainerResourceRequirements(
        limits.map(value => value),
        requests.map(value => value)
      )
    def limits: Optional[Map[String, Quantity]]
    def requests: Optional[Map[String, Quantity]]
    def getLimits: ZIO[Any, AwsError, Map[String, Quantity]] =
      AwsError.unwrapOptionField("limits", limits)
    def getRequests: ZIO[Any, AwsError, Map[String, Quantity]] =
      AwsError.unwrapOptionField("requests", requests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EksContainerResourceRequirements
  ) extends zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly {
    override val limits: Optional[Map[String, Quantity]] = zio.aws.core.internal
      .optionalFromNullable(impl.limits())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.batch.model.primitives.Quantity(value)
          })
          .toMap
      )
    override val requests: Optional[Map[String, Quantity]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requests())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.batch.model.primitives.Quantity(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EksContainerResourceRequirements
  ): zio.aws.batch.model.EksContainerResourceRequirements.ReadOnly =
    new Wrapper(impl)
}
