package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Volume(
    host: Optional[zio.aws.batch.model.Host] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    efsVolumeConfiguration: Optional[
      zio.aws.batch.model.EFSVolumeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.batch.model.Volume = {
    import Volume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.Volume
      .builder()
      .optionallyWith(host.map(value => value.buildAwsValue()))(_.host)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        efsVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.efsVolumeConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.Volume.ReadOnly =
    zio.aws.batch.model.Volume.wrap(buildAwsValue())
}
object Volume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.Volume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.Volume = zio.aws.batch.model.Volume(
      host.map(value => value.asEditable),
      name.map(value => value),
      efsVolumeConfiguration.map(value => value.asEditable)
    )
    def host: Optional[zio.aws.batch.model.Host.ReadOnly]
    def name: Optional[String]
    def efsVolumeConfiguration
        : Optional[zio.aws.batch.model.EFSVolumeConfiguration.ReadOnly]
    def getHost: ZIO[Any, AwsError, zio.aws.batch.model.Host.ReadOnly] =
      AwsError.unwrapOptionField("host", host)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getEfsVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EFSVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "efsVolumeConfiguration",
      efsVolumeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.Volume
  ) extends zio.aws.batch.model.Volume.ReadOnly {
    override val host: Optional[zio.aws.batch.model.Host.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.host())
        .map(value => zio.aws.batch.model.Host.wrap(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val efsVolumeConfiguration
        : Optional[zio.aws.batch.model.EFSVolumeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.efsVolumeConfiguration())
        .map(value => zio.aws.batch.model.EFSVolumeConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.Volume
  ): zio.aws.batch.model.Volume.ReadOnly = new Wrapper(impl)
}
