package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ArrayPropertiesDetail(
    statusSummary: Optional[Map[String, Integer]] = Optional.Absent,
    size: Optional[Integer] = Optional.Absent,
    index: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail = {
    import ArrayPropertiesDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
      .builder()
      .optionallyWith(
        statusSummary.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Integer)
            })
            .asJava
        )
      )(_.statusSummary)
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly =
    zio.aws.batch.model.ArrayPropertiesDetail.wrap(buildAwsValue())
}
object ArrayPropertiesDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ArrayPropertiesDetail =
      zio.aws.batch.model.ArrayPropertiesDetail(
        statusSummary.map(value => value),
        size.map(value => value),
        index.map(value => value)
      )
    def statusSummary: Optional[Map[String, Integer]]
    def size: Optional[Integer]
    def index: Optional[Integer]
    def getStatusSummary: ZIO[Any, AwsError, Map[String, Integer]] =
      AwsError.unwrapOptionField("statusSummary", statusSummary)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
  ) extends zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly {
    override val statusSummary: Optional[Map[String, Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusSummary())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: Integer)
            })
            .toMap
        )
    override val size: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Integer)
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesDetail
  ): zio.aws.batch.model.ArrayPropertiesDetail.ReadOnly = new Wrapper(impl)
}
