package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateJobQueueRequest(
    jobQueue: String,
    state: Optional[zio.aws.batch.model.JQState] = Optional.Absent,
    schedulingPolicyArn: Optional[String] = Optional.Absent,
    priority: Optional[Integer] = Optional.Absent,
    computeEnvironmentOrder: Optional[
      Iterable[zio.aws.batch.model.ComputeEnvironmentOrder]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest = {
    import UpdateJobQueueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
      .builder()
      .jobQueue(jobQueue: java.lang.String)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        schedulingPolicyArn.map(value => value: java.lang.String)
      )(_.schedulingPolicyArn)
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(
        computeEnvironmentOrder.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computeEnvironmentOrder)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.UpdateJobQueueRequest.ReadOnly =
    zio.aws.batch.model.UpdateJobQueueRequest.wrap(buildAwsValue())
}
object UpdateJobQueueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UpdateJobQueueRequest =
      zio.aws.batch.model.UpdateJobQueueRequest(
        jobQueue,
        state.map(value => value),
        schedulingPolicyArn.map(value => value),
        priority.map(value => value),
        computeEnvironmentOrder.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobQueue: String
    def state: Optional[zio.aws.batch.model.JQState]
    def schedulingPolicyArn: Optional[String]
    def priority: Optional[Integer]
    def computeEnvironmentOrder
        : Optional[List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly]]
    def getJobQueue: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueue)
    def getState: ZIO[Any, AwsError, zio.aws.batch.model.JQState] =
      AwsError.unwrapOptionField("state", state)
    def getSchedulingPolicyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schedulingPolicyArn", schedulingPolicyArn)
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getComputeEnvironmentOrder: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "computeEnvironmentOrder",
      computeEnvironmentOrder
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
  ) extends zio.aws.batch.model.UpdateJobQueueRequest.ReadOnly {
    override val jobQueue: String = impl.jobQueue(): String
    override val state: Optional[zio.aws.batch.model.JQState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.batch.model.JQState.wrap(value))
    override val schedulingPolicyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schedulingPolicyArn())
      .map(value => value: String)
    override val priority: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Integer)
    override val computeEnvironmentOrder
        : Optional[List[zio.aws.batch.model.ComputeEnvironmentOrder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeEnvironmentOrder())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.ComputeEnvironmentOrder.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest
  ): zio.aws.batch.model.UpdateJobQueueRequest.ReadOnly = new Wrapper(impl)
}
