package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ArrayPropertiesSummary(
    size: Optional[Integer] = Optional.Absent,
    index: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary = {
    import ArrayPropertiesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
      .builder()
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly =
    zio.aws.batch.model.ArrayPropertiesSummary.wrap(buildAwsValue())
}
object ArrayPropertiesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ArrayPropertiesSummary =
      zio.aws.batch.model.ArrayPropertiesSummary(
        size.map(value => value),
        index.map(value => value)
      )
    def size: Optional[Integer]
    def index: Optional[Integer]
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
  ) extends zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly {
    override val size: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Integer)
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ArrayPropertiesSummary
  ): zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly = new Wrapper(impl)
}
