package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SchedulingPolicyDetail(
    name: String,
    arn: String,
    fairsharePolicy: Optional[zio.aws.batch.model.FairsharePolicy] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.SchedulingPolicyDetail = {
    import SchedulingPolicyDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.SchedulingPolicyDetail
      .builder()
      .name(name: java.lang.String)
      .arn(arn: java.lang.String)
      .optionallyWith(fairsharePolicy.map(value => value.buildAwsValue()))(
        _.fairsharePolicy
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.SchedulingPolicyDetail.ReadOnly =
    zio.aws.batch.model.SchedulingPolicyDetail.wrap(buildAwsValue())
}
object SchedulingPolicyDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.SchedulingPolicyDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.SchedulingPolicyDetail =
      zio.aws.batch.model.SchedulingPolicyDetail(
        name,
        arn,
        fairsharePolicy.map(value => value.asEditable),
        tags.map(value => value)
      )
    def name: String
    def arn: String
    def fairsharePolicy: Optional[zio.aws.batch.model.FairsharePolicy.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getFairsharePolicy
        : ZIO[Any, AwsError, zio.aws.batch.model.FairsharePolicy.ReadOnly] =
      AwsError.unwrapOptionField("fairsharePolicy", fairsharePolicy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.SchedulingPolicyDetail
  ) extends zio.aws.batch.model.SchedulingPolicyDetail.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: String = impl.arn(): String
    override val fairsharePolicy
        : Optional[zio.aws.batch.model.FairsharePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fairsharePolicy())
        .map(value => zio.aws.batch.model.FairsharePolicy.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.SchedulingPolicyDetail
  ): zio.aws.batch.model.SchedulingPolicyDetail.ReadOnly = new Wrapper(impl)
}
