package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateComputeEnvironmentResponse(
    computeEnvironmentName: Optional[String] = Optional.Absent,
    computeEnvironmentArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse = {
    import UpdateComputeEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse
      .builder()
      .optionallyWith(
        computeEnvironmentName.map(value => value: java.lang.String)
      )(_.computeEnvironmentName)
      .optionallyWith(
        computeEnvironmentArn.map(value => value: java.lang.String)
      )(_.computeEnvironmentArn)
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly =
    zio.aws.batch.model.UpdateComputeEnvironmentResponse.wrap(buildAwsValue())
}
object UpdateComputeEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UpdateComputeEnvironmentResponse =
      zio.aws.batch.model.UpdateComputeEnvironmentResponse(
        computeEnvironmentName.map(value => value),
        computeEnvironmentArn.map(value => value)
      )
    def computeEnvironmentName: Optional[String]
    def computeEnvironmentArn: Optional[String]
    def getComputeEnvironmentName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("computeEnvironmentName", computeEnvironmentName)
    def getComputeEnvironmentArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("computeEnvironmentArn", computeEnvironmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse
  ) extends zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly {
    override val computeEnvironmentName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computeEnvironmentName())
        .map(value => value: String)
    override val computeEnvironmentArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.computeEnvironmentArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse
  ): zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
