package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobTimeout(
    attemptDurationSeconds: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.JobTimeout = {
    import JobTimeout.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.JobTimeout
      .builder()
      .optionallyWith(
        attemptDurationSeconds.map(value => value: java.lang.Integer)
      )(_.attemptDurationSeconds)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.JobTimeout.ReadOnly =
    zio.aws.batch.model.JobTimeout.wrap(buildAwsValue())
}
object JobTimeout {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.JobTimeout] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.JobTimeout =
      zio.aws.batch.model.JobTimeout(attemptDurationSeconds.map(value => value))
    def attemptDurationSeconds: Optional[Integer]
    def getAttemptDurationSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("attemptDurationSeconds", attemptDurationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.JobTimeout
  ) extends zio.aws.batch.model.JobTimeout.ReadOnly {
    override val attemptDurationSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attemptDurationSeconds())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.JobTimeout
  ): zio.aws.batch.model.JobTimeout.ReadOnly = new Wrapper(impl)
}
