package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait PlatformCapability {
  def unwrap: software.amazon.awssdk.services.batch.model.PlatformCapability
}
object PlatformCapability {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.PlatformCapability
  ): zio.aws.batch.model.PlatformCapability = value match {
    case software.amazon.awssdk.services.batch.model.PlatformCapability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.PlatformCapability.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.batch.model.PlatformCapability.FARGATE =>
      val r = FARGATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.PlatformCapability {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.PlatformCapability =
      software.amazon.awssdk.services.batch.model.PlatformCapability.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.batch.model.PlatformCapability {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.PlatformCapability =
      software.amazon.awssdk.services.batch.model.PlatformCapability.EC2
  }
  case object FARGATE extends zio.aws.batch.model.PlatformCapability {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.PlatformCapability =
      software.amazon.awssdk.services.batch.model.PlatformCapability.FARGATE
  }
}
