package zio.aws.batch.model
import zio.aws.batch.model.primitives.{ImageIdOverride, ImageType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ec2Configuration(
    imageType: ImageType,
    imageIdOverride: Optional[ImageIdOverride] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.Ec2Configuration = {
    import Ec2Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.Ec2Configuration
      .builder()
      .imageType(ImageType.unwrap(imageType): java.lang.String)
      .optionallyWith(
        imageIdOverride.map(value =>
          ImageIdOverride.unwrap(value): java.lang.String
        )
      )(_.imageIdOverride)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.Ec2Configuration.ReadOnly =
    zio.aws.batch.model.Ec2Configuration.wrap(buildAwsValue())
}
object Ec2Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.Ec2Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.Ec2Configuration = zio.aws.batch.model
      .Ec2Configuration(imageType, imageIdOverride.map(value => value))
    def imageType: ImageType
    def imageIdOverride: Optional[ImageIdOverride]
    def getImageType: ZIO[Any, Nothing, ImageType] = ZIO.succeed(imageType)
    def getImageIdOverride: ZIO[Any, AwsError, ImageIdOverride] =
      AwsError.unwrapOptionField("imageIdOverride", imageIdOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.Ec2Configuration
  ) extends zio.aws.batch.model.Ec2Configuration.ReadOnly {
    override val imageType: ImageType =
      zio.aws.batch.model.primitives.ImageType(impl.imageType())
    override val imageIdOverride: Optional[ImageIdOverride] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageIdOverride())
        .map(value => zio.aws.batch.model.primitives.ImageIdOverride(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.Ec2Configuration
  ): zio.aws.batch.model.Ec2Configuration.ReadOnly = new Wrapper(impl)
}
