package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait DeviceCgroupPermission {
  def unwrap: software.amazon.awssdk.services.batch.model.DeviceCgroupPermission
}
object DeviceCgroupPermission {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.DeviceCgroupPermission
  ): zio.aws.batch.model.DeviceCgroupPermission = value match {
    case software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.READ =>
      val r = READ
      r
    case software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.WRITE =>
      val r = WRITE
      r
    case software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.MKNOD =>
      val r = MKNOD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.batch.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.UNKNOWN_TO_SDK_VERSION
  }
  case object READ extends zio.aws.batch.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.READ
  }
  case object WRITE extends zio.aws.batch.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.WRITE
  }
  case object MKNOD extends zio.aws.batch.model.DeviceCgroupPermission {
    override def unwrap
        : software.amazon.awssdk.services.batch.model.DeviceCgroupPermission =
      software.amazon.awssdk.services.batch.model.DeviceCgroupPermission.MKNOD
  }
}
