package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerProperties(
    image: Optional[String] = Optional.Absent,
    vcpus: Optional[Integer] = Optional.Absent,
    memory: Optional[Integer] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    jobRoleArn: Optional[String] = Optional.Absent,
    executionRoleArn: Optional[String] = Optional.Absent,
    volumes: Optional[Iterable[zio.aws.batch.model.Volume]] = Optional.Absent,
    environment: Optional[Iterable[zio.aws.batch.model.KeyValuePair]] =
      Optional.Absent,
    mountPoints: Optional[Iterable[zio.aws.batch.model.MountPoint]] =
      Optional.Absent,
    readonlyRootFilesystem: Optional[Boolean] = Optional.Absent,
    privileged: Optional[Boolean] = Optional.Absent,
    ulimits: Optional[Iterable[zio.aws.batch.model.Ulimit]] = Optional.Absent,
    user: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    resourceRequirements: Optional[
      Iterable[zio.aws.batch.model.ResourceRequirement]
    ] = Optional.Absent,
    linuxParameters: Optional[zio.aws.batch.model.LinuxParameters] =
      Optional.Absent,
    logConfiguration: Optional[zio.aws.batch.model.LogConfiguration] =
      Optional.Absent,
    secrets: Optional[Iterable[zio.aws.batch.model.Secret]] = Optional.Absent,
    networkConfiguration: Optional[zio.aws.batch.model.NetworkConfiguration] =
      Optional.Absent,
    fargatePlatformConfiguration: Optional[
      zio.aws.batch.model.FargatePlatformConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ContainerProperties = {
    import ContainerProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ContainerProperties
      .builder()
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(vcpus.map(value => value: java.lang.Integer))(_.vcpus)
      .optionallyWith(memory.map(value => value: java.lang.Integer))(_.memory)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(jobRoleArn.map(value => value: java.lang.String))(
        _.jobRoleArn
      )
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        mountPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountPoints)
      .optionallyWith(
        readonlyRootFilesystem.map(value => value: java.lang.Boolean)
      )(_.readonlyRootFilesystem)
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .optionallyWith(
        ulimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ulimits)
      .optionallyWith(user.map(value => value: java.lang.String))(_.user)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .optionallyWith(linuxParameters.map(value => value.buildAwsValue()))(
        _.linuxParameters
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        secrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secrets)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        fargatePlatformConfiguration.map(value => value.buildAwsValue())
      )(_.fargatePlatformConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ContainerProperties.ReadOnly =
    zio.aws.batch.model.ContainerProperties.wrap(buildAwsValue())
}
object ContainerProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ContainerProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ContainerProperties =
      zio.aws.batch.model.ContainerProperties(
        image.map(value => value),
        vcpus.map(value => value),
        memory.map(value => value),
        command.map(value => value),
        jobRoleArn.map(value => value),
        executionRoleArn.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mountPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        readonlyRootFilesystem.map(value => value),
        privileged.map(value => value),
        ulimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        user.map(value => value),
        instanceType.map(value => value),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        linuxParameters.map(value => value.asEditable),
        logConfiguration.map(value => value.asEditable),
        secrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkConfiguration.map(value => value.asEditable),
        fargatePlatformConfiguration.map(value => value.asEditable)
      )
    def image: Optional[String]
    def vcpus: Optional[Integer]
    def memory: Optional[Integer]
    def command: Optional[List[String]]
    def jobRoleArn: Optional[String]
    def executionRoleArn: Optional[String]
    def volumes: Optional[List[zio.aws.batch.model.Volume.ReadOnly]]
    def environment: Optional[List[zio.aws.batch.model.KeyValuePair.ReadOnly]]
    def mountPoints: Optional[List[zio.aws.batch.model.MountPoint.ReadOnly]]
    def readonlyRootFilesystem: Optional[Boolean]
    def privileged: Optional[Boolean]
    def ulimits: Optional[List[zio.aws.batch.model.Ulimit.ReadOnly]]
    def user: Optional[String]
    def instanceType: Optional[String]
    def resourceRequirements
        : Optional[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]]
    def linuxParameters: Optional[zio.aws.batch.model.LinuxParameters.ReadOnly]
    def logConfiguration
        : Optional[zio.aws.batch.model.LogConfiguration.ReadOnly]
    def secrets: Optional[List[zio.aws.batch.model.Secret.ReadOnly]]
    def networkConfiguration
        : Optional[zio.aws.batch.model.NetworkConfiguration.ReadOnly]
    def fargatePlatformConfiguration
        : Optional[zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly]
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getVcpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vcpus", vcpus)
    def getMemory: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memory", memory)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getJobRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobRoleArn", jobRoleArn)
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.batch.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getMountPoints
        : ZIO[Any, AwsError, List[zio.aws.batch.model.MountPoint.ReadOnly]] =
      AwsError.unwrapOptionField("mountPoints", mountPoints)
    def getReadonlyRootFilesystem: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("readonlyRootFilesystem", readonlyRootFilesystem)
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
    def getUlimits
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Ulimit.ReadOnly]] =
      AwsError.unwrapOptionField("ulimits", ulimits)
    def getUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("user", user)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
    def getLinuxParameters
        : ZIO[Any, AwsError, zio.aws.batch.model.LinuxParameters.ReadOnly] =
      AwsError.unwrapOptionField("linuxParameters", linuxParameters)
    def getLogConfiguration
        : ZIO[Any, AwsError, zio.aws.batch.model.LogConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getSecrets
        : ZIO[Any, AwsError, List[zio.aws.batch.model.Secret.ReadOnly]] =
      AwsError.unwrapOptionField("secrets", secrets)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.NetworkConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getFargatePlatformConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fargatePlatformConfiguration",
      fargatePlatformConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ContainerProperties
  ) extends zio.aws.batch.model.ContainerProperties.ReadOnly {
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val vcpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vcpus())
      .map(value => value: Integer)
    override val memory: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: Integer)
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val jobRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.jobRoleArn())
      .map(value => value: String)
    override val executionRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => value: String)
    override val volumes: Optional[List[zio.aws.batch.model.Volume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Volume.wrap(item)
          }.toList
        )
    override val environment
        : Optional[List[zio.aws.batch.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.KeyValuePair.wrap(item)
          }.toList
        )
    override val mountPoints
        : Optional[List[zio.aws.batch.model.MountPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.MountPoint.wrap(item)
          }.toList
        )
    override val readonlyRootFilesystem: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readonlyRootFilesystem())
        .map(value => value: Boolean)
    override val privileged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: Boolean)
    override val ulimits: Optional[List[zio.aws.batch.model.Ulimit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ulimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Ulimit.wrap(item)
          }.toList
        )
    override val user: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val resourceRequirements
        : Optional[List[zio.aws.batch.model.ResourceRequirement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.ResourceRequirement.wrap(item)
          }.toList
        )
    override val linuxParameters
        : Optional[zio.aws.batch.model.LinuxParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.linuxParameters())
        .map(value => zio.aws.batch.model.LinuxParameters.wrap(value))
    override val logConfiguration
        : Optional[zio.aws.batch.model.LogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value => zio.aws.batch.model.LogConfiguration.wrap(value))
    override val secrets: Optional[List[zio.aws.batch.model.Secret.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secrets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.Secret.wrap(item)
          }.toList
        )
    override val networkConfiguration
        : Optional[zio.aws.batch.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.batch.model.NetworkConfiguration.wrap(value))
    override val fargatePlatformConfiguration
        : Optional[zio.aws.batch.model.FargatePlatformConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fargatePlatformConfiguration())
        .map(value =>
          zio.aws.batch.model.FargatePlatformConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ContainerProperties
  ): zio.aws.batch.model.ContainerProperties.ReadOnly = new Wrapper(impl)
}
