package zio.aws.batch.model
import scala.jdk.CollectionConverters._
sealed trait CEType {
  def unwrap: software.amazon.awssdk.services.batch.model.CEType
}
object CEType {
  def wrap(
      value: software.amazon.awssdk.services.batch.model.CEType
  ): zio.aws.batch.model.CEType = value match {
    case software.amazon.awssdk.services.batch.model.CEType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.batch.model.CEType.MANAGED =>
      val r = MANAGED
      r
    case software.amazon.awssdk.services.batch.model.CEType.UNMANAGED =>
      val r = UNMANAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.batch.model.CEType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEType =
      software.amazon.awssdk.services.batch.model.CEType.UNKNOWN_TO_SDK_VERSION
  }
  case object MANAGED extends zio.aws.batch.model.CEType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEType =
      software.amazon.awssdk.services.batch.model.CEType.MANAGED
  }
  case object UNMANAGED extends zio.aws.batch.model.CEType {
    override def unwrap: software.amazon.awssdk.services.batch.model.CEType =
      software.amazon.awssdk.services.batch.model.CEType.UNMANAGED
  }
}
