package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerSummary(
    exitCode: Optional[Integer] = Optional.Absent,
    reason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ContainerSummary = {
    import ContainerSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ContainerSummary
      .builder()
      .optionallyWith(exitCode.map(value => value: java.lang.Integer))(
        _.exitCode
      )
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ContainerSummary.ReadOnly =
    zio.aws.batch.model.ContainerSummary.wrap(buildAwsValue())
}
object ContainerSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ContainerSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ContainerSummary =
      zio.aws.batch.model.ContainerSummary(
        exitCode.map(value => value),
        reason.map(value => value)
      )
    def exitCode: Optional[Integer]
    def reason: Optional[String]
    def getExitCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ContainerSummary
  ) extends zio.aws.batch.model.ContainerSummary.ReadOnly {
    override val exitCode: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.exitCode())
      .map(value => value: Integer)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ContainerSummary
  ): zio.aws.batch.model.ContainerSummary.ReadOnly = new Wrapper(impl)
}
