package zio.aws.batch
import zio.aws.batch.model.SubmitJobResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.batch.model.{
  ListSchedulingPoliciesRequest,
  DescribeJobQueuesRequest,
  SubmitJobRequest,
  CreateSchedulingPolicyRequest,
  DeleteComputeEnvironmentRequest,
  CancelJobRequest,
  UpdateJobQueueRequest,
  ListJobsRequest,
  CreateComputeEnvironmentRequest,
  UpdateComputeEnvironmentRequest,
  DescribeSchedulingPoliciesRequest,
  ListTagsForResourceRequest,
  DeleteSchedulingPolicyRequest,
  DescribeComputeEnvironmentsRequest,
  UpdateSchedulingPolicyRequest,
  DeleteJobQueueRequest,
  DescribeJobsRequest,
  DeregisterJobDefinitionRequest,
  RegisterJobDefinitionRequest,
  DescribeJobDefinitionsRequest,
  TerminateJobRequest,
  UntagResourceRequest,
  CreateJobQueueRequest,
  TagResourceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.batch.BatchAsyncClient
import zio.stream.ZStream
object BatchMock extends Mock[Batch] {
  object SubmitJob extends Effect[SubmitJobRequest, AwsError, ReadOnly]
  object DeleteSchedulingPolicy
      extends Effect[
        DeleteSchedulingPolicyRequest,
        AwsError,
        zio.aws.batch.model.DeleteSchedulingPolicyResponse.ReadOnly
      ]
  object DescribeComputeEnvironments
      extends Stream[
        DescribeComputeEnvironmentsRequest,
        AwsError,
        zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly
      ]
  object DescribeComputeEnvironmentsPaginated
      extends Effect[
        DescribeComputeEnvironmentsRequest,
        AwsError,
        zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly
      ]
  object RegisterJobDefinition
      extends Effect[
        RegisterJobDefinitionRequest,
        AwsError,
        zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly
      ]
  object DescribeJobQueues
      extends Stream[
        DescribeJobQueuesRequest,
        AwsError,
        zio.aws.batch.model.JobQueueDetail.ReadOnly
      ]
  object DescribeJobQueuesPaginated
      extends Effect[
        DescribeJobQueuesRequest,
        AwsError,
        zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly
      ]
  object DescribeSchedulingPolicies
      extends Effect[
        DescribeSchedulingPoliciesRequest,
        AwsError,
        zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly
      ]
  object UpdateComputeEnvironment
      extends Effect[
        UpdateComputeEnvironmentRequest,
        AwsError,
        zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly
      ]
  object CreateJobQueue
      extends Effect[
        CreateJobQueueRequest,
        AwsError,
        zio.aws.batch.model.CreateJobQueueResponse.ReadOnly
      ]
  object CancelJob
      extends Effect[
        CancelJobRequest,
        AwsError,
        zio.aws.batch.model.CancelJobResponse.ReadOnly
      ]
  object UpdateJobQueue
      extends Effect[
        UpdateJobQueueRequest,
        AwsError,
        zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly
      ]
  object DeregisterJobDefinition
      extends Effect[
        DeregisterJobDefinitionRequest,
        AwsError,
        zio.aws.batch.model.DeregisterJobDefinitionResponse.ReadOnly
      ]
  object TerminateJob
      extends Effect[
        TerminateJobRequest,
        AwsError,
        zio.aws.batch.model.TerminateJobResponse.ReadOnly
      ]
  object DescribeJobs
      extends Effect[
        DescribeJobsRequest,
        AwsError,
        zio.aws.batch.model.DescribeJobsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.batch.model.UntagResourceResponse.ReadOnly
      ]
  object CreateSchedulingPolicy
      extends Effect[
        CreateSchedulingPolicyRequest,
        AwsError,
        zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.batch.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListJobs
      extends Stream[
        ListJobsRequest,
        AwsError,
        zio.aws.batch.model.JobSummary.ReadOnly
      ]
  object ListJobsPaginated
      extends Effect[
        ListJobsRequest,
        AwsError,
        zio.aws.batch.model.ListJobsResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.batch.model.TagResourceResponse.ReadOnly
      ]
  object DescribeJobDefinitions
      extends Stream[
        DescribeJobDefinitionsRequest,
        AwsError,
        zio.aws.batch.model.JobDefinition.ReadOnly
      ]
  object DescribeJobDefinitionsPaginated
      extends Effect[
        DescribeJobDefinitionsRequest,
        AwsError,
        zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly
      ]
  object UpdateSchedulingPolicy
      extends Effect[
        UpdateSchedulingPolicyRequest,
        AwsError,
        zio.aws.batch.model.UpdateSchedulingPolicyResponse.ReadOnly
      ]
  object CreateComputeEnvironment
      extends Effect[
        CreateComputeEnvironmentRequest,
        AwsError,
        zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly
      ]
  object DeleteComputeEnvironment
      extends Effect[
        DeleteComputeEnvironmentRequest,
        AwsError,
        zio.aws.batch.model.DeleteComputeEnvironmentResponse.ReadOnly
      ]
  object ListSchedulingPolicies
      extends Stream[
        ListSchedulingPoliciesRequest,
        AwsError,
        zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly
      ]
  object ListSchedulingPoliciesPaginated
      extends Effect[
        ListSchedulingPoliciesRequest,
        AwsError,
        zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly
      ]
  object DeleteJobQueue
      extends Effect[
        DeleteJobQueueRequest,
        AwsError,
        zio.aws.batch.model.DeleteJobQueueResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Batch] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Batch {
          val api: BatchAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Batch = this
          def submitJob(request: SubmitJobRequest): IO[AwsError, ReadOnly] =
            proxy(SubmitJob, request)
          def deleteSchedulingPolicy(
              request: DeleteSchedulingPolicyRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.DeleteSchedulingPolicyResponse.ReadOnly
          ] = proxy(DeleteSchedulingPolicy, request)
          def describeComputeEnvironments(
              request: DescribeComputeEnvironmentsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeComputeEnvironments, request))
          def describeComputeEnvironmentsPaginated(
              request: DescribeComputeEnvironmentsRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly
          ] = proxy(DescribeComputeEnvironmentsPaginated, request)
          def registerJobDefinition(request: RegisterJobDefinitionRequest): IO[
            AwsError,
            zio.aws.batch.model.RegisterJobDefinitionResponse.ReadOnly
          ] = proxy(RegisterJobDefinition, request)
          def describeJobQueues(request: DescribeJobQueuesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.batch.model.JobQueueDetail.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeJobQueues, request))
          def describeJobQueuesPaginated(request: DescribeJobQueuesRequest): IO[
            AwsError,
            zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly
          ] = proxy(DescribeJobQueuesPaginated, request)
          def describeSchedulingPolicies(
              request: DescribeSchedulingPoliciesRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.DescribeSchedulingPoliciesResponse.ReadOnly
          ] = proxy(DescribeSchedulingPolicies, request)
          def updateComputeEnvironment(
              request: UpdateComputeEnvironmentRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.UpdateComputeEnvironmentResponse.ReadOnly
          ] = proxy(UpdateComputeEnvironment, request)
          def createJobQueue(
              request: CreateJobQueueRequest
          ): IO[AwsError, zio.aws.batch.model.CreateJobQueueResponse.ReadOnly] =
            proxy(CreateJobQueue, request)
          def cancelJob(
              request: CancelJobRequest
          ): IO[AwsError, zio.aws.batch.model.CancelJobResponse.ReadOnly] =
            proxy(CancelJob, request)
          def updateJobQueue(
              request: UpdateJobQueueRequest
          ): IO[AwsError, zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly] =
            proxy(UpdateJobQueue, request)
          def deregisterJobDefinition(
              request: DeregisterJobDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.DeregisterJobDefinitionResponse.ReadOnly
          ] = proxy(DeregisterJobDefinition, request)
          def terminateJob(
              request: TerminateJobRequest
          ): IO[AwsError, zio.aws.batch.model.TerminateJobResponse.ReadOnly] =
            proxy(TerminateJob, request)
          def describeJobs(
              request: DescribeJobsRequest
          ): IO[AwsError, zio.aws.batch.model.DescribeJobsResponse.ReadOnly] =
            proxy(DescribeJobs, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.batch.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def createSchedulingPolicy(
              request: CreateSchedulingPolicyRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.CreateSchedulingPolicyResponse.ReadOnly
          ] = proxy(CreateSchedulingPolicy, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.batch.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def listJobs(
              request: ListJobsRequest
          ): ZStream[Any, AwsError, zio.aws.batch.model.JobSummary.ReadOnly] =
            rts.unsafeRun(proxy(ListJobs, request))
          def listJobsPaginated(
              request: ListJobsRequest
          ): IO[AwsError, zio.aws.batch.model.ListJobsResponse.ReadOnly] =
            proxy(ListJobsPaginated, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.batch.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def describeJobDefinitions(
              request: DescribeJobDefinitionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.batch.model.JobDefinition.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeJobDefinitions, request))
          def describeJobDefinitionsPaginated(
              request: DescribeJobDefinitionsRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.DescribeJobDefinitionsResponse.ReadOnly
          ] = proxy(DescribeJobDefinitionsPaginated, request)
          def updateSchedulingPolicy(
              request: UpdateSchedulingPolicyRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.UpdateSchedulingPolicyResponse.ReadOnly
          ] = proxy(UpdateSchedulingPolicy, request)
          def createComputeEnvironment(
              request: CreateComputeEnvironmentRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly
          ] = proxy(CreateComputeEnvironment, request)
          def deleteComputeEnvironment(
              request: DeleteComputeEnvironmentRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.DeleteComputeEnvironmentResponse.ReadOnly
          ] = proxy(DeleteComputeEnvironment, request)
          def listSchedulingPolicies(
              request: ListSchedulingPoliciesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.batch.model.SchedulingPolicyListingDetail.ReadOnly
          ] = rts.unsafeRun(proxy(ListSchedulingPolicies, request))
          def listSchedulingPoliciesPaginated(
              request: ListSchedulingPoliciesRequest
          ): IO[
            AwsError,
            zio.aws.batch.model.ListSchedulingPoliciesResponse.ReadOnly
          ] = proxy(ListSchedulingPoliciesPaginated, request)
          def deleteJobQueue(
              request: DeleteJobQueueRequest
          ): IO[AwsError, zio.aws.batch.model.DeleteJobQueueResponse.ReadOnly] =
            proxy(DeleteJobQueue, request)
        }
      }
    }
  }
}
