package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComputeResourceUpdate(
    minvCpus: Optional[Integer] = Optional.Absent,
    maxvCpus: Optional[Integer] = Optional.Absent,
    desiredvCpus: Optional[Integer] = Optional.Absent,
    subnets: Optional[Iterable[String]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ComputeResourceUpdate = {
    import ComputeResourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
      .builder()
      .optionallyWith(minvCpus.map(value => value: java.lang.Integer))(
        _.minvCpus
      )
      .optionallyWith(maxvCpus.map(value => value: java.lang.Integer))(
        _.maxvCpus
      )
      .optionallyWith(desiredvCpus.map(value => value: java.lang.Integer))(
        _.desiredvCpus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ComputeResourceUpdate.ReadOnly =
    zio.aws.batch.model.ComputeResourceUpdate.wrap(buildAwsValue())
}
object ComputeResourceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ComputeResourceUpdate =
      zio.aws.batch.model.ComputeResourceUpdate(
        minvCpus.map(value => value),
        maxvCpus.map(value => value),
        desiredvCpus.map(value => value),
        subnets.map(value => value),
        securityGroupIds.map(value => value)
      )
    def minvCpus: Optional[Integer]
    def maxvCpus: Optional[Integer]
    def desiredvCpus: Optional[Integer]
    def subnets: Optional[List[String]]
    def securityGroupIds: Optional[List[String]]
    def getMinvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minvCpus", minvCpus)
    def getMaxvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxvCpus", maxvCpus)
    def getDesiredvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredvCpus", desiredvCpus)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ) extends zio.aws.batch.model.ComputeResourceUpdate.ReadOnly {
    override val minvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minvCpus())
      .map(value => value: Integer)
    override val maxvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxvCpus())
      .map(value => value: Integer)
    override val desiredvCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredvCpus())
      .map(value => value: Integer)
    override val subnets: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ): zio.aws.batch.model.ComputeResourceUpdate.ReadOnly = new Wrapper(impl)
}
