package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateComputeEnvironmentRequest(
    computeEnvironment: String,
    state: Option[zio.aws.batch.model.CEState] = None,
    unmanagedvCpus: Option[Integer] = None,
    computeResources: Option[zio.aws.batch.model.ComputeResourceUpdate] = None,
    serviceRole: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest = {
    import UpdateComputeEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest
      .builder()
      .computeEnvironment(computeEnvironment: java.lang.String)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(unmanagedvCpus.map(value => value: java.lang.Integer))(
        _.unmanagedvCpus
      )
      .optionallyWith(computeResources.map(value => value.buildAwsValue()))(
        _.computeResources
      )
      .optionallyWith(serviceRole.map(value => value: java.lang.String))(
        _.serviceRole
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.UpdateComputeEnvironmentRequest.ReadOnly =
    zio.aws.batch.model.UpdateComputeEnvironmentRequest.wrap(buildAwsValue())
}
object UpdateComputeEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UpdateComputeEnvironmentRequest =
      zio.aws.batch.model.UpdateComputeEnvironmentRequest(
        computeEnvironment,
        state.map(value => value),
        unmanagedvCpus.map(value => value),
        computeResources.map(value => value.asEditable),
        serviceRole.map(value => value)
      )
    def computeEnvironment: String
    def state: Option[zio.aws.batch.model.CEState]
    def unmanagedvCpus: Option[Integer]
    def computeResources
        : Option[zio.aws.batch.model.ComputeResourceUpdate.ReadOnly]
    def serviceRole: Option[String]
    def getComputeEnvironment: ZIO[Any, Nothing, String] =
      ZIO.succeed(computeEnvironment)
    def getState: ZIO[Any, AwsError, zio.aws.batch.model.CEState] =
      AwsError.unwrapOptionField("state", state)
    def getUnmanagedvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("unmanagedvCpus", unmanagedvCpus)
    def getComputeResources: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.ComputeResourceUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("computeResources", computeResources)
    def getServiceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest
  ) extends zio.aws.batch.model.UpdateComputeEnvironmentRequest.ReadOnly {
    override val computeEnvironment: String = impl.computeEnvironment(): String
    override val state: Option[zio.aws.batch.model.CEState] = scala
      .Option(impl.state())
      .map(value => zio.aws.batch.model.CEState.wrap(value))
    override val unmanagedvCpus: Option[Integer] =
      scala.Option(impl.unmanagedvCpus()).map(value => value: Integer)
    override val computeResources
        : Option[zio.aws.batch.model.ComputeResourceUpdate.ReadOnly] = scala
      .Option(impl.computeResources())
      .map(value => zio.aws.batch.model.ComputeResourceUpdate.wrap(value))
    override val serviceRole: Option[String] =
      scala.Option(impl.serviceRole()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest
  ): zio.aws.batch.model.UpdateComputeEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
