package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EvaluateOnExit(
    onStatusReason: Option[String] = None,
    onReason: Option[String] = None,
    onExitCode: Option[String] = None,
    action: zio.aws.batch.model.RetryAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EvaluateOnExit = {
    import EvaluateOnExit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EvaluateOnExit
      .builder()
      .optionallyWith(onStatusReason.map(value => value: java.lang.String))(
        _.onStatusReason
      )
      .optionallyWith(onReason.map(value => value: java.lang.String))(
        _.onReason
      )
      .optionallyWith(onExitCode.map(value => value: java.lang.String))(
        _.onExitCode
      )
      .action(action.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EvaluateOnExit.ReadOnly =
    zio.aws.batch.model.EvaluateOnExit.wrap(buildAwsValue())
}
object EvaluateOnExit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EvaluateOnExit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EvaluateOnExit =
      zio.aws.batch.model.EvaluateOnExit(
        onStatusReason.map(value => value),
        onReason.map(value => value),
        onExitCode.map(value => value),
        action
      )
    def onStatusReason: Option[String]
    def onReason: Option[String]
    def onExitCode: Option[String]
    def action: zio.aws.batch.model.RetryAction
    def getOnStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onStatusReason", onStatusReason)
    def getOnReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onReason", onReason)
    def getOnExitCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("onExitCode", onExitCode)
    def getAction: ZIO[Any, Nothing, zio.aws.batch.model.RetryAction] =
      ZIO.succeed(action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EvaluateOnExit
  ) extends zio.aws.batch.model.EvaluateOnExit.ReadOnly {
    override val onStatusReason: Option[String] =
      scala.Option(impl.onStatusReason()).map(value => value: String)
    override val onReason: Option[String] =
      scala.Option(impl.onReason()).map(value => value: String)
    override val onExitCode: Option[String] =
      scala.Option(impl.onExitCode()).map(value => value: String)
    override val action: zio.aws.batch.model.RetryAction =
      zio.aws.batch.model.RetryAction.wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EvaluateOnExit
  ): zio.aws.batch.model.EvaluateOnExit.ReadOnly = new Wrapper(impl)
}
