package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeComputeEnvironmentsResponse(
    computeEnvironments: Option[
      Iterable[zio.aws.batch.model.ComputeEnvironmentDetail]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse = {
    import DescribeComputeEnvironmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
      .builder()
      .optionallyWith(
        computeEnvironments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computeEnvironments)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly =
    zio.aws.batch.model.DescribeComputeEnvironmentsResponse
      .wrap(buildAwsValue())
}
object DescribeComputeEnvironmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeComputeEnvironmentsResponse =
      zio.aws.batch.model.DescribeComputeEnvironmentsResponse(
        computeEnvironments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def computeEnvironments
        : Option[List[zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly]]
    def nextToken: Option[String]
    def getComputeEnvironments: ZIO[Any, AwsError, List[
      zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("computeEnvironments", computeEnvironments)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
  ) extends zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly {
    override val computeEnvironments
        : Option[List[zio.aws.batch.model.ComputeEnvironmentDetail.ReadOnly]] =
      scala
        .Option(impl.computeEnvironments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.batch.model.ComputeEnvironmentDetail.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse
  ): zio.aws.batch.model.DescribeComputeEnvironmentsResponse.ReadOnly =
    new Wrapper(impl)
}
