package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EFSVolumeConfiguration(
    fileSystemId: String,
    rootDirectory: Option[String] = None,
    transitEncryption: Option[zio.aws.batch.model.EFSTransitEncryption] = None,
    transitEncryptionPort: Option[Integer] = None,
    authorizationConfig: Option[zio.aws.batch.model.EFSAuthorizationConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.EFSVolumeConfiguration = {
    import EFSVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.EFSVolumeConfiguration
      .builder()
      .fileSystemId(fileSystemId: java.lang.String)
      .optionallyWith(rootDirectory.map(value => value: java.lang.String))(
        _.rootDirectory
      )
      .optionallyWith(transitEncryption.map(value => value.unwrap))(
        _.transitEncryption
      )
      .optionallyWith(
        transitEncryptionPort.map(value => value: java.lang.Integer)
      )(_.transitEncryptionPort)
      .optionallyWith(authorizationConfig.map(value => value.buildAwsValue()))(
        _.authorizationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.EFSVolumeConfiguration.ReadOnly =
    zio.aws.batch.model.EFSVolumeConfiguration.wrap(buildAwsValue())
}
object EFSVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.EFSVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.EFSVolumeConfiguration =
      zio.aws.batch.model.EFSVolumeConfiguration(
        fileSystemId,
        rootDirectory.map(value => value),
        transitEncryption.map(value => value),
        transitEncryptionPort.map(value => value),
        authorizationConfig.map(value => value.asEditable)
      )
    def fileSystemId: String
    def rootDirectory: Option[String]
    def transitEncryption: Option[zio.aws.batch.model.EFSTransitEncryption]
    def transitEncryptionPort: Option[Integer]
    def authorizationConfig
        : Option[zio.aws.batch.model.EFSAuthorizationConfig.ReadOnly]
    def getFileSystemId: ZIO[Any, Nothing, String] = ZIO.succeed(fileSystemId)
    def getRootDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDirectory", rootDirectory)
    def getTransitEncryption
        : ZIO[Any, AwsError, zio.aws.batch.model.EFSTransitEncryption] =
      AwsError.unwrapOptionField("transitEncryption", transitEncryption)
    def getTransitEncryptionPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transitEncryptionPort", transitEncryptionPort)
    def getAuthorizationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.EFSAuthorizationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("authorizationConfig", authorizationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.EFSVolumeConfiguration
  ) extends zio.aws.batch.model.EFSVolumeConfiguration.ReadOnly {
    override val fileSystemId: String = impl.fileSystemId(): String
    override val rootDirectory: Option[String] =
      scala.Option(impl.rootDirectory()).map(value => value: String)
    override val transitEncryption
        : Option[zio.aws.batch.model.EFSTransitEncryption] = scala
      .Option(impl.transitEncryption())
      .map(value => zio.aws.batch.model.EFSTransitEncryption.wrap(value))
    override val transitEncryptionPort: Option[Integer] =
      scala.Option(impl.transitEncryptionPort()).map(value => value: Integer)
    override val authorizationConfig
        : Option[zio.aws.batch.model.EFSAuthorizationConfig.ReadOnly] = scala
      .Option(impl.authorizationConfig())
      .map(value => zio.aws.batch.model.EFSAuthorizationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.EFSVolumeConfiguration
  ): zio.aws.batch.model.EFSVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
