package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SubmitJobRequest(
    jobName: String,
    jobQueue: String,
    shareIdentifier: Option[String] = None,
    schedulingPriorityOverride: Option[Integer] = None,
    arrayProperties: Option[zio.aws.batch.model.ArrayProperties] = None,
    dependsOn: Option[Iterable[zio.aws.batch.model.JobDependency]] = None,
    jobDefinition: String,
    parameters: Option[Map[String, String]] = None,
    containerOverrides: Option[zio.aws.batch.model.ContainerOverrides] = None,
    nodeOverrides: Option[zio.aws.batch.model.NodeOverrides] = None,
    retryStrategy: Option[zio.aws.batch.model.RetryStrategy] = None,
    propagateTags: Option[Boolean] = None,
    timeout: Option[zio.aws.batch.model.JobTimeout] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.SubmitJobRequest = {
    import SubmitJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.SubmitJobRequest
      .builder()
      .jobName(jobName: java.lang.String)
      .jobQueue(jobQueue: java.lang.String)
      .optionallyWith(shareIdentifier.map(value => value: java.lang.String))(
        _.shareIdentifier
      )
      .optionallyWith(
        schedulingPriorityOverride.map(value => value: java.lang.Integer)
      )(_.schedulingPriorityOverride)
      .optionallyWith(arrayProperties.map(value => value.buildAwsValue()))(
        _.arrayProperties
      )
      .optionallyWith(
        dependsOn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependsOn)
      .jobDefinition(jobDefinition: java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(containerOverrides.map(value => value.buildAwsValue()))(
        _.containerOverrides
      )
      .optionallyWith(nodeOverrides.map(value => value.buildAwsValue()))(
        _.nodeOverrides
      )
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .optionallyWith(propagateTags.map(value => value: java.lang.Boolean))(
        _.propagateTags
      )
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.SubmitJobRequest.ReadOnly =
    zio.aws.batch.model.SubmitJobRequest.wrap(buildAwsValue())
}
object SubmitJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.SubmitJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.SubmitJobRequest =
      zio.aws.batch.model.SubmitJobRequest(
        jobName,
        jobQueue,
        shareIdentifier.map(value => value),
        schedulingPriorityOverride.map(value => value),
        arrayProperties.map(value => value.asEditable),
        dependsOn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jobDefinition,
        parameters.map(value => value),
        containerOverrides.map(value => value.asEditable),
        nodeOverrides.map(value => value.asEditable),
        retryStrategy.map(value => value.asEditable),
        propagateTags.map(value => value),
        timeout.map(value => value.asEditable),
        tags.map(value => value)
      )
    def jobName: String
    def jobQueue: String
    def shareIdentifier: Option[String]
    def schedulingPriorityOverride: Option[Integer]
    def arrayProperties: Option[zio.aws.batch.model.ArrayProperties.ReadOnly]
    def dependsOn: Option[List[zio.aws.batch.model.JobDependency.ReadOnly]]
    def jobDefinition: String
    def parameters: Option[Map[String, String]]
    def containerOverrides
        : Option[zio.aws.batch.model.ContainerOverrides.ReadOnly]
    def nodeOverrides: Option[zio.aws.batch.model.NodeOverrides.ReadOnly]
    def retryStrategy: Option[zio.aws.batch.model.RetryStrategy.ReadOnly]
    def propagateTags: Option[Boolean]
    def timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getJobName: ZIO[Any, Nothing, String] = ZIO.succeed(jobName)
    def getJobQueue: ZIO[Any, Nothing, String] = ZIO.succeed(jobQueue)
    def getShareIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("shareIdentifier", shareIdentifier)
    def getSchedulingPriorityOverride: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "schedulingPriorityOverride",
        schedulingPriorityOverride
      )
    def getArrayProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.ArrayProperties.ReadOnly] =
      AwsError.unwrapOptionField("arrayProperties", arrayProperties)
    def getDependsOn
        : ZIO[Any, AwsError, List[zio.aws.batch.model.JobDependency.ReadOnly]] =
      AwsError.unwrapOptionField("dependsOn", dependsOn)
    def getJobDefinition: ZIO[Any, Nothing, String] = ZIO.succeed(jobDefinition)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getContainerOverrides
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerOverrides.ReadOnly] =
      AwsError.unwrapOptionField("containerOverrides", containerOverrides)
    def getNodeOverrides
        : ZIO[Any, AwsError, zio.aws.batch.model.NodeOverrides.ReadOnly] =
      AwsError.unwrapOptionField("nodeOverrides", nodeOverrides)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.batch.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getPropagateTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.batch.model.JobTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.SubmitJobRequest
  ) extends zio.aws.batch.model.SubmitJobRequest.ReadOnly {
    override val jobName: String = impl.jobName(): String
    override val jobQueue: String = impl.jobQueue(): String
    override val shareIdentifier: Option[String] =
      scala.Option(impl.shareIdentifier()).map(value => value: String)
    override val schedulingPriorityOverride: Option[Integer] = scala
      .Option(impl.schedulingPriorityOverride())
      .map(value => value: Integer)
    override val arrayProperties
        : Option[zio.aws.batch.model.ArrayProperties.ReadOnly] = scala
      .Option(impl.arrayProperties())
      .map(value => zio.aws.batch.model.ArrayProperties.wrap(value))
    override val dependsOn
        : Option[List[zio.aws.batch.model.JobDependency.ReadOnly]] = scala
      .Option(impl.dependsOn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.JobDependency.wrap(item)
        }.toList
      )
    override val jobDefinition: String = impl.jobDefinition(): String
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val containerOverrides
        : Option[zio.aws.batch.model.ContainerOverrides.ReadOnly] = scala
      .Option(impl.containerOverrides())
      .map(value => zio.aws.batch.model.ContainerOverrides.wrap(value))
    override val nodeOverrides
        : Option[zio.aws.batch.model.NodeOverrides.ReadOnly] = scala
      .Option(impl.nodeOverrides())
      .map(value => zio.aws.batch.model.NodeOverrides.wrap(value))
    override val retryStrategy
        : Option[zio.aws.batch.model.RetryStrategy.ReadOnly] = scala
      .Option(impl.retryStrategy())
      .map(value => zio.aws.batch.model.RetryStrategy.wrap(value))
    override val propagateTags: Option[Boolean] =
      scala.Option(impl.propagateTags()).map(value => value: Boolean)
    override val timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly] =
      scala
        .Option(impl.timeout())
        .map(value => zio.aws.batch.model.JobTimeout.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.SubmitJobRequest
  ): zio.aws.batch.model.SubmitJobRequest.ReadOnly = new Wrapper(impl)
}
