package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MountPoint(
    containerPath: Option[String] = None,
    readOnly: Option[Boolean] = None,
    sourceVolume: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.MountPoint = {
    import MountPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.MountPoint
      .builder()
      .optionallyWith(containerPath.map(value => value: java.lang.String))(
        _.containerPath
      )
      .optionallyWith(readOnly.map(value => value: java.lang.Boolean))(
        _.readOnly
      )
      .optionallyWith(sourceVolume.map(value => value: java.lang.String))(
        _.sourceVolume
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.MountPoint.ReadOnly =
    zio.aws.batch.model.MountPoint.wrap(buildAwsValue())
}
object MountPoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.MountPoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.MountPoint =
      zio.aws.batch.model.MountPoint(
        containerPath.map(value => value),
        readOnly.map(value => value),
        sourceVolume.map(value => value)
      )
    def containerPath: Option[String]
    def readOnly: Option[Boolean]
    def sourceVolume: Option[String]
    def getContainerPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerPath", containerPath)
    def getReadOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getSourceVolume: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVolume", sourceVolume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.MountPoint
  ) extends zio.aws.batch.model.MountPoint.ReadOnly {
    override val containerPath: Option[String] =
      scala.Option(impl.containerPath()).map(value => value: String)
    override val readOnly: Option[Boolean] =
      scala.Option(impl.readOnly()).map(value => value: Boolean)
    override val sourceVolume: Option[String] =
      scala.Option(impl.sourceVolume()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.MountPoint
  ): zio.aws.batch.model.MountPoint.ReadOnly = new Wrapper(impl)
}
