package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobSummary(
    jobArn: Option[String] = None,
    jobId: String,
    jobName: String,
    createdAt: Option[Long] = None,
    status: Option[zio.aws.batch.model.JobStatus] = None,
    statusReason: Option[String] = None,
    startedAt: Option[Long] = None,
    stoppedAt: Option[Long] = None,
    container: Option[zio.aws.batch.model.ContainerSummary] = None,
    arrayProperties: Option[zio.aws.batch.model.ArrayPropertiesSummary] = None,
    nodeProperties: Option[zio.aws.batch.model.NodePropertiesSummary] = None,
    jobDefinition: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.JobSummary
      .builder()
      .optionallyWith(jobArn.map(value => value: java.lang.String))(_.jobArn)
      .jobId(jobId: java.lang.String)
      .jobName(jobName: java.lang.String)
      .optionallyWith(createdAt.map(value => value: java.lang.Long))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(startedAt.map(value => value: java.lang.Long))(
        _.startedAt
      )
      .optionallyWith(stoppedAt.map(value => value: java.lang.Long))(
        _.stoppedAt
      )
      .optionallyWith(container.map(value => value.buildAwsValue()))(
        _.container
      )
      .optionallyWith(arrayProperties.map(value => value.buildAwsValue()))(
        _.arrayProperties
      )
      .optionallyWith(nodeProperties.map(value => value.buildAwsValue()))(
        _.nodeProperties
      )
      .optionallyWith(jobDefinition.map(value => value: java.lang.String))(
        _.jobDefinition
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.JobSummary.ReadOnly =
    zio.aws.batch.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.batch.model.JobSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.JobSummary =
      zio.aws.batch.model.JobSummary(
        jobArn.map(value => value),
        jobId,
        jobName,
        createdAt.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        startedAt.map(value => value),
        stoppedAt.map(value => value),
        container.map(value => value.asEditable),
        arrayProperties.map(value => value.asEditable),
        nodeProperties.map(value => value.asEditable),
        jobDefinition.map(value => value)
      )
    def jobArn: Option[String]
    def jobId: String
    def jobName: String
    def createdAt: Option[Long]
    def status: Option[zio.aws.batch.model.JobStatus]
    def statusReason: Option[String]
    def startedAt: Option[Long]
    def stoppedAt: Option[Long]
    def container: Option[zio.aws.batch.model.ContainerSummary.ReadOnly]
    def arrayProperties
        : Option[zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly]
    def nodeProperties
        : Option[zio.aws.batch.model.NodePropertiesSummary.ReadOnly]
    def jobDefinition: Option[String]
    def getJobArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobId: ZIO[Any, Nothing, String] = ZIO.succeed(jobId)
    def getJobName: ZIO[Any, Nothing, String] = ZIO.succeed(jobName)
    def getCreatedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.batch.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getStartedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStoppedAt: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getContainer
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerSummary.ReadOnly] =
      AwsError.unwrapOptionField("container", container)
    def getArrayProperties: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly
    ] = AwsError.unwrapOptionField("arrayProperties", arrayProperties)
    def getNodeProperties: ZIO[
      Any,
      AwsError,
      zio.aws.batch.model.NodePropertiesSummary.ReadOnly
    ] = AwsError.unwrapOptionField("nodeProperties", nodeProperties)
    def getJobDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobDefinition", jobDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.JobSummary
  ) extends zio.aws.batch.model.JobSummary.ReadOnly {
    override val jobArn: Option[String] =
      scala.Option(impl.jobArn()).map(value => value: String)
    override val jobId: String = impl.jobId(): String
    override val jobName: String = impl.jobName(): String
    override val createdAt: Option[Long] =
      scala.Option(impl.createdAt()).map(value => value: Long)
    override val status: Option[zio.aws.batch.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.batch.model.JobStatus.wrap(value))
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
    override val startedAt: Option[Long] =
      scala.Option(impl.startedAt()).map(value => value: Long)
    override val stoppedAt: Option[Long] =
      scala.Option(impl.stoppedAt()).map(value => value: Long)
    override val container
        : Option[zio.aws.batch.model.ContainerSummary.ReadOnly] = scala
      .Option(impl.container())
      .map(value => zio.aws.batch.model.ContainerSummary.wrap(value))
    override val arrayProperties
        : Option[zio.aws.batch.model.ArrayPropertiesSummary.ReadOnly] = scala
      .Option(impl.arrayProperties())
      .map(value => zio.aws.batch.model.ArrayPropertiesSummary.wrap(value))
    override val nodeProperties
        : Option[zio.aws.batch.model.NodePropertiesSummary.ReadOnly] = scala
      .Option(impl.nodeProperties())
      .map(value => zio.aws.batch.model.NodePropertiesSummary.wrap(value))
    override val jobDefinition: Option[String] =
      scala.Option(impl.jobDefinition()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.JobSummary
  ): zio.aws.batch.model.JobSummary.ReadOnly = new Wrapper(impl)
}
