package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateJobQueueResponse(
    jobQueueName: Option[String] = None,
    jobQueueArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse = {
    import UpdateJobQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse
      .builder()
      .optionallyWith(jobQueueName.map(value => value: java.lang.String))(
        _.jobQueueName
      )
      .optionallyWith(jobQueueArn.map(value => value: java.lang.String))(
        _.jobQueueArn
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly =
    zio.aws.batch.model.UpdateJobQueueResponse.wrap(buildAwsValue())
}
object UpdateJobQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.UpdateJobQueueResponse =
      zio.aws.batch.model.UpdateJobQueueResponse(
        jobQueueName.map(value => value),
        jobQueueArn.map(value => value)
      )
    def jobQueueName: Option[String]
    def jobQueueArn: Option[String]
    def getJobQueueName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobQueueName", jobQueueName)
    def getJobQueueArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobQueueArn", jobQueueArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse
  ) extends zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly {
    override val jobQueueName: Option[String] =
      scala.Option(impl.jobQueueName()).map(value => value: String)
    override val jobQueueArn: Option[String] =
      scala.Option(impl.jobQueueArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse
  ): zio.aws.batch.model.UpdateJobQueueResponse.ReadOnly = new Wrapper(impl)
}
