package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListJobsResponse(
    jobSummaryList: Iterable[zio.aws.batch.model.JobSummary],
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ListJobsResponse
      .builder()
      .jobSummaryList(jobSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ListJobsResponse.ReadOnly =
    zio.aws.batch.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ListJobsResponse =
      zio.aws.batch.model.ListJobsResponse(
        jobSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobSummaryList: List[zio.aws.batch.model.JobSummary.ReadOnly]
    def nextToken: Option[String]
    def getJobSummaryList
        : ZIO[Any, Nothing, List[zio.aws.batch.model.JobSummary.ReadOnly]] =
      ZIO.succeed(jobSummaryList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ListJobsResponse
  ) extends zio.aws.batch.model.ListJobsResponse.ReadOnly {
    override val jobSummaryList: List[zio.aws.batch.model.JobSummary.ReadOnly] =
      impl
        .jobSummaryList()
        .asScala
        .map { item =>
          zio.aws.batch.model.JobSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ListJobsResponse
  ): zio.aws.batch.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
