package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComputeResourceUpdate(
    minvCpus: Option[Integer] = None,
    maxvCpus: Option[Integer] = None,
    desiredvCpus: Option[Integer] = None,
    subnets: Option[Iterable[String]] = None,
    securityGroupIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ComputeResourceUpdate = {
    import ComputeResourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
      .builder()
      .optionallyWith(minvCpus.map(value => value: java.lang.Integer))(
        _.minvCpus
      )
      .optionallyWith(maxvCpus.map(value => value: java.lang.Integer))(
        _.maxvCpus
      )
      .optionallyWith(desiredvCpus.map(value => value: java.lang.Integer))(
        _.desiredvCpus
      )
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ComputeResourceUpdate.ReadOnly =
    zio.aws.batch.model.ComputeResourceUpdate.wrap(buildAwsValue())
}
object ComputeResourceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ComputeResourceUpdate =
      zio.aws.batch.model.ComputeResourceUpdate(
        minvCpus.map(value => value),
        maxvCpus.map(value => value),
        desiredvCpus.map(value => value),
        subnets.map(value => value),
        securityGroupIds.map(value => value)
      )
    def minvCpus: Option[Integer]
    def maxvCpus: Option[Integer]
    def desiredvCpus: Option[Integer]
    def subnets: Option[List[String]]
    def securityGroupIds: Option[List[String]]
    def getMinvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minvCpus", minvCpus)
    def getMaxvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxvCpus", maxvCpus)
    def getDesiredvCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredvCpus", desiredvCpus)
    def getSubnets: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ) extends zio.aws.batch.model.ComputeResourceUpdate.ReadOnly {
    override val minvCpus: Option[Integer] =
      scala.Option(impl.minvCpus()).map(value => value: Integer)
    override val maxvCpus: Option[Integer] =
      scala.Option(impl.maxvCpus()).map(value => value: Integer)
    override val desiredvCpus: Option[Integer] =
      scala.Option(impl.desiredvCpus()).map(value => value: Integer)
    override val subnets: Option[List[String]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ComputeResourceUpdate
  ): zio.aws.batch.model.ComputeResourceUpdate.ReadOnly = new Wrapper(impl)
}
