package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListJobsRequest(
    jobQueue: Option[String] = None,
    arrayJobId: Option[String] = None,
    multiNodeJobId: Option[String] = None,
    jobStatus: Option[zio.aws.batch.model.JobStatus] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    filters: Option[Iterable[zio.aws.batch.model.KeyValuesPair]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.ListJobsRequest = {
    import ListJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.ListJobsRequest
      .builder()
      .optionallyWith(jobQueue.map(value => value: java.lang.String))(
        _.jobQueue
      )
      .optionallyWith(arrayJobId.map(value => value: java.lang.String))(
        _.arrayJobId
      )
      .optionallyWith(multiNodeJobId.map(value => value: java.lang.String))(
        _.multiNodeJobId
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.ListJobsRequest.ReadOnly =
    zio.aws.batch.model.ListJobsRequest.wrap(buildAwsValue())
}
object ListJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.ListJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.ListJobsRequest =
      zio.aws.batch.model.ListJobsRequest(
        jobQueue.map(value => value),
        arrayJobId.map(value => value),
        multiNodeJobId.map(value => value),
        jobStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobQueue: Option[String]
    def arrayJobId: Option[String]
    def multiNodeJobId: Option[String]
    def jobStatus: Option[zio.aws.batch.model.JobStatus]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def filters: Option[List[zio.aws.batch.model.KeyValuesPair.ReadOnly]]
    def getJobQueue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobQueue", jobQueue)
    def getArrayJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arrayJobId", arrayJobId)
    def getMultiNodeJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("multiNodeJobId", multiNodeJobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.batch.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.batch.model.KeyValuesPair.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.ListJobsRequest
  ) extends zio.aws.batch.model.ListJobsRequest.ReadOnly {
    override val jobQueue: Option[String] =
      scala.Option(impl.jobQueue()).map(value => value: String)
    override val arrayJobId: Option[String] =
      scala.Option(impl.arrayJobId()).map(value => value: String)
    override val multiNodeJobId: Option[String] =
      scala.Option(impl.multiNodeJobId()).map(value => value: String)
    override val jobStatus: Option[zio.aws.batch.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.batch.model.JobStatus.wrap(value))
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val filters
        : Option[List[zio.aws.batch.model.KeyValuesPair.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.KeyValuesPair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.ListJobsRequest
  ): zio.aws.batch.model.ListJobsRequest.ReadOnly = new Wrapper(impl)
}
