package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeJobQueuesResponse(
    jobQueues: Option[Iterable[zio.aws.batch.model.JobQueueDetail]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse = {
    import DescribeJobQueuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse
      .builder()
      .optionallyWith(
        jobQueues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobQueues)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly =
    zio.aws.batch.model.DescribeJobQueuesResponse.wrap(buildAwsValue())
}
object DescribeJobQueuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeJobQueuesResponse =
      zio.aws.batch.model.DescribeJobQueuesResponse(
        jobQueues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def jobQueues: Option[List[zio.aws.batch.model.JobQueueDetail.ReadOnly]]
    def nextToken: Option[String]
    def getJobQueues: ZIO[Any, AwsError, List[
      zio.aws.batch.model.JobQueueDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("jobQueues", jobQueues)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse
  ) extends zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly {
    override val jobQueues
        : Option[List[zio.aws.batch.model.JobQueueDetail.ReadOnly]] = scala
      .Option(impl.jobQueues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.JobQueueDetail.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse
  ): zio.aws.batch.model.DescribeJobQueuesResponse.ReadOnly = new Wrapper(impl)
}
