package zio.aws.batch.model
import zio.aws.batch.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeComputeEnvironmentsRequest(
    computeEnvironments: Option[Iterable[String]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest = {
    import DescribeComputeEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
      .builder()
      .optionallyWith(
        computeEnvironments.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.computeEnvironments)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.DescribeComputeEnvironmentsRequest.ReadOnly =
    zio.aws.batch.model.DescribeComputeEnvironmentsRequest.wrap(buildAwsValue())
}
object DescribeComputeEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.DescribeComputeEnvironmentsRequest =
      zio.aws.batch.model.DescribeComputeEnvironmentsRequest(
        computeEnvironments.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def computeEnvironments: Option[List[String]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getComputeEnvironments: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("computeEnvironments", computeEnvironments)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
  ) extends zio.aws.batch.model.DescribeComputeEnvironmentsRequest.ReadOnly {
    override val computeEnvironments: Option[List[String]] = scala
      .Option(impl.computeEnvironments())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest
  ): zio.aws.batch.model.DescribeComputeEnvironmentsRequest.ReadOnly =
    new Wrapper(impl)
}
