package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateComputeEnvironmentResponse(
    computeEnvironmentName: Option[String] = None,
    computeEnvironmentArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse = {
    import CreateComputeEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
      .builder()
      .optionallyWith(
        computeEnvironmentName.map(value => value: java.lang.String)
      )(_.computeEnvironmentName)
      .optionallyWith(
        computeEnvironmentArn.map(value => value: java.lang.String)
      )(_.computeEnvironmentArn)
      .build()
  }
  def asReadOnly
      : zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly =
    zio.aws.batch.model.CreateComputeEnvironmentResponse.wrap(buildAwsValue())
}
object CreateComputeEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.CreateComputeEnvironmentResponse =
      zio.aws.batch.model.CreateComputeEnvironmentResponse(
        computeEnvironmentName.map(value => value),
        computeEnvironmentArn.map(value => value)
      )
    def computeEnvironmentName: Option[String]
    def computeEnvironmentArn: Option[String]
    def getComputeEnvironmentName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("computeEnvironmentName", computeEnvironmentName)
    def getComputeEnvironmentArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("computeEnvironmentArn", computeEnvironmentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
  ) extends zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly {
    override val computeEnvironmentName: Option[String] =
      scala.Option(impl.computeEnvironmentName()).map(value => value: String)
    override val computeEnvironmentArn: Option[String] =
      scala.Option(impl.computeEnvironmentArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse
  ): zio.aws.batch.model.CreateComputeEnvironmentResponse.ReadOnly =
    new Wrapper(impl)
}
