package zio.aws.batch.model
import zio.aws.batch.model.primitives.{TagValue, TagKey, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterJobDefinitionRequest(
    jobDefinitionName: String,
    `type`: zio.aws.batch.model.JobDefinitionType,
    parameters: Option[Map[String, String]] = None,
    schedulingPriority: Option[Integer] = None,
    containerProperties: Option[zio.aws.batch.model.ContainerProperties] = None,
    nodeProperties: Option[zio.aws.batch.model.NodeProperties] = None,
    retryStrategy: Option[zio.aws.batch.model.RetryStrategy] = None,
    propagateTags: Option[Boolean] = None,
    timeout: Option[zio.aws.batch.model.JobTimeout] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    platformCapabilities: Option[
      Iterable[zio.aws.batch.model.PlatformCapability]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest = {
    import RegisterJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest
      .builder()
      .jobDefinitionName(jobDefinitionName: java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        schedulingPriority.map(value => value: java.lang.Integer)
      )(_.schedulingPriority)
      .optionallyWith(containerProperties.map(value => value.buildAwsValue()))(
        _.containerProperties
      )
      .optionallyWith(nodeProperties.map(value => value.buildAwsValue()))(
        _.nodeProperties
      )
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .optionallyWith(propagateTags.map(value => value: java.lang.Boolean))(
        _.propagateTags
      )
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        platformCapabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.platformCapabilitiesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.RegisterJobDefinitionRequest.ReadOnly =
    zio.aws.batch.model.RegisterJobDefinitionRequest.wrap(buildAwsValue())
}
object RegisterJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.RegisterJobDefinitionRequest =
      zio.aws.batch.model.RegisterJobDefinitionRequest(
        jobDefinitionName,
        `type`,
        parameters.map(value => value),
        schedulingPriority.map(value => value),
        containerProperties.map(value => value.asEditable),
        nodeProperties.map(value => value.asEditable),
        retryStrategy.map(value => value.asEditable),
        propagateTags.map(value => value),
        timeout.map(value => value.asEditable),
        tags.map(value => value),
        platformCapabilities.map(value => value)
      )
    def jobDefinitionName: String
    def `type`: zio.aws.batch.model.JobDefinitionType
    def parameters: Option[Map[String, String]]
    def schedulingPriority: Option[Integer]
    def containerProperties
        : Option[zio.aws.batch.model.ContainerProperties.ReadOnly]
    def nodeProperties: Option[zio.aws.batch.model.NodeProperties.ReadOnly]
    def retryStrategy: Option[zio.aws.batch.model.RetryStrategy.ReadOnly]
    def propagateTags: Option[Boolean]
    def timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def platformCapabilities
        : Option[List[zio.aws.batch.model.PlatformCapability]]
    def getJobDefinitionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(jobDefinitionName)
    def getType: ZIO[Any, Nothing, zio.aws.batch.model.JobDefinitionType] =
      ZIO.succeed(`type`)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getSchedulingPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("schedulingPriority", schedulingPriority)
    def getContainerProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.ContainerProperties.ReadOnly] =
      AwsError.unwrapOptionField("containerProperties", containerProperties)
    def getNodeProperties
        : ZIO[Any, AwsError, zio.aws.batch.model.NodeProperties.ReadOnly] =
      AwsError.unwrapOptionField("nodeProperties", nodeProperties)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.batch.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getPropagateTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.batch.model.JobTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPlatformCapabilities
        : ZIO[Any, AwsError, List[zio.aws.batch.model.PlatformCapability]] =
      AwsError.unwrapOptionField("platformCapabilities", platformCapabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest
  ) extends zio.aws.batch.model.RegisterJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: String = impl.jobDefinitionName(): String
    override val `type`: zio.aws.batch.model.JobDefinitionType =
      zio.aws.batch.model.JobDefinitionType.wrap(impl.`type`())
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val schedulingPriority: Option[Integer] =
      scala.Option(impl.schedulingPriority()).map(value => value: Integer)
    override val containerProperties
        : Option[zio.aws.batch.model.ContainerProperties.ReadOnly] = scala
      .Option(impl.containerProperties())
      .map(value => zio.aws.batch.model.ContainerProperties.wrap(value))
    override val nodeProperties
        : Option[zio.aws.batch.model.NodeProperties.ReadOnly] = scala
      .Option(impl.nodeProperties())
      .map(value => zio.aws.batch.model.NodeProperties.wrap(value))
    override val retryStrategy
        : Option[zio.aws.batch.model.RetryStrategy.ReadOnly] = scala
      .Option(impl.retryStrategy())
      .map(value => zio.aws.batch.model.RetryStrategy.wrap(value))
    override val propagateTags: Option[Boolean] =
      scala.Option(impl.propagateTags()).map(value => value: Boolean)
    override val timeout: Option[zio.aws.batch.model.JobTimeout.ReadOnly] =
      scala
        .Option(impl.timeout())
        .map(value => zio.aws.batch.model.JobTimeout.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.batch.model.primitives
              .TagKey(key) -> zio.aws.batch.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val platformCapabilities
        : Option[List[zio.aws.batch.model.PlatformCapability]] = scala
      .Option(impl.platformCapabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.batch.model.PlatformCapability.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest
  ): zio.aws.batch.model.RegisterJobDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
