package zio.aws.batch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class JobDependency(
    jobId: Option[String] = None,
    `type`: Option[zio.aws.batch.model.ArrayJobDependency] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.batch.model.JobDependency = {
    import JobDependency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.batch.model.JobDependency
      .builder()
      .optionallyWith(jobId.map(value => value: java.lang.String))(_.jobId)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.batch.model.JobDependency.ReadOnly =
    zio.aws.batch.model.JobDependency.wrap(buildAwsValue())
}
object JobDependency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.batch.model.JobDependency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.batch.model.JobDependency = zio.aws.batch.model
      .JobDependency(jobId.map(value => value), `type`.map(value => value))
    def jobId: Option[String]
    def `type`: Option[zio.aws.batch.model.ArrayJobDependency]
    def getJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getType: ZIO[Any, AwsError, zio.aws.batch.model.ArrayJobDependency] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.batch.model.JobDependency
  ) extends zio.aws.batch.model.JobDependency.ReadOnly {
    override val jobId: Option[String] =
      scala.Option(impl.jobId()).map(value => value: String)
    override val `type`: Option[zio.aws.batch.model.ArrayJobDependency] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.batch.model.ArrayJobDependency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.batch.model.JobDependency
  ): zio.aws.batch.model.JobDependency.ReadOnly = new Wrapper(impl)
}
